/*
Szymon Rusinkiewicz

ward_panel1.cc
The panel for the Ward BRDF.
It works together with ward_panel.c, which is generated automatically by
fdesign.

Note that we automatically replace thebrdf by a rotated BRDF, so that we can
provide rotation control in the panel. Yes, I *know* that's ugly...
*/

#include "bv_brdf_panels.h"
#include "brdf_ward.h"
#include "brdf_rotate.h"

extern "C" {
#include "ward_panel.h"
}

#define BRDF_SX_UNROTATED (((Ward_BRDF *)thebrdf)->sx)
#define BRDF_SY_UNROTATED (((Ward_BRDF *)thebrdf)->sy)
#define BRDF_RS_UNROTATED (((Ward_BRDF *)thebrdf)->rs)
#define BRDF_RD_UNROTATED (((Ward_BRDF *)thebrdf)->rd)
#define BRDF_SX_ROTATED (((Ward_BRDF *)(((Rotate_BRDF *)thebrdf)->b))->sx)
#define BRDF_SY_ROTATED (((Ward_BRDF *)(((Rotate_BRDF *)thebrdf)->b))->sy)
#define BRDF_RS_ROTATED (((Ward_BRDF *)(((Rotate_BRDF *)thebrdf)->b))->rs)
#define BRDF_RD_ROTATED (((Ward_BRDF *)(((Rotate_BRDF *)thebrdf)->b))->rd)
#define BRDF_PHI (((Rotate_BRDF *)thebrdf)->phi)
#define BRDF_SX BRDF_SX_ROTATED
#define BRDF_SY BRDF_SY_ROTATED
#define BRDF_RS BRDF_RS_ROTATED
#define BRDF_RD BRDF_RD_ROTATED

#define HELP1 "This is Greg Ward's Elliptical Gaussian BRDF."
#define HELP2 "It is predicted by a simple, but physically correct,"
#define HELP3 "rough-surface model, assuming different surface"
#define HELP4 "roughness along the X and Y directions. Shadowing,"
#define HELP5 "masking and Fresnel reflection are not included."

static FD_ward_panel *fd_ward_panel;

void Ward_panel_sx_callback(FL_OBJECT *ob, long data)
{
	BRDF_SX = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Ward_panel_sy_callback(FL_OBJECT *ob, long data)
{
	BRDF_SY = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Ward_panel_rs_callback(FL_OBJECT *ob, long data)
{
	BRDF_RS = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Ward_panel_rd_callback(FL_OBJECT *ob, long data)
{
	BRDF_RD = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Ward_rotation_callback(FL_OBJECT *ob, long data)
{
	float phi = fl_get_dial_value(ob);
	if (phi > 180)
		phi -= 360;
	BRDF_PHI = -deg2rad(phi);
	BRDFchanged = TRUE;
}


FL_FORM *ward_panel_init()
{
	float oldsx=BRDF_SX_UNROTATED, oldsy=BRDF_SY_UNROTATED;
	float oldrs=BRDF_RS_UNROTATED, oldrd=BRDF_RD_UNROTATED;
	delete thebrdf;
	char c[255];
	sprintf(c,"rotate %f ward %f %f %f %f",0.0, oldsx, oldsy, oldrs, oldrd);
	thebrdf = BRDF::Create(c);

	fd_ward_panel = create_form_ward_panel();

	fl_set_slider_return(fd_ward_panel->Ward_panel_sx, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ward_panel->Ward_panel_sx, 0.01, 0.5);
	fl_set_slider_value(fd_ward_panel->Ward_panel_sx, BRDF_SX);
	fl_set_slider_return(fd_ward_panel->Ward_panel_sy, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ward_panel->Ward_panel_sy, 0.01, 0.5);
	fl_set_slider_value(fd_ward_panel->Ward_panel_sy, BRDF_SY);
	fl_set_slider_return(fd_ward_panel->Ward_panel_rs, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ward_panel->Ward_panel_rs, 0, 1);
	fl_set_slider_value(fd_ward_panel->Ward_panel_rs, BRDF_RS);
	fl_set_slider_return(fd_ward_panel->Ward_panel_rd, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ward_panel->Ward_panel_rd, 0, 1);
	fl_set_slider_value(fd_ward_panel->Ward_panel_rd, BRDF_RD);

	fl_set_dial_cross(fd_ward_panel->Ward_rotation, TRUE);
	fl_set_dial_return(fd_ward_panel->Ward_rotation, BV_PANEL_RETURN);
	fl_set_dial_bounds(fd_ward_panel->Ward_rotation, 0, 360);
	fl_set_dial_value(fd_ward_panel->Ward_rotation, 0);

	fl_add_browser_line(fd_ward_panel->Helptext,HELP1);
	fl_add_browser_line(fd_ward_panel->Helptext,HELP2);
	fl_add_browser_line(fd_ward_panel->Helptext,HELP3);
	fl_add_browser_line(fd_ward_panel->Helptext,HELP4);
	fl_add_browser_line(fd_ward_panel->Helptext,HELP5);

	return fd_ward_panel->ward_panel;
}
