/*
Szymon Rusinkiewicz

ts_panel1.cc
The panel for the Torrance-Sparrow BRDF.
It works together with ts_panel.c, which is generated automatically by fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_ts.h"

extern "C" {
#include "ts_panel.h"
}

#define BRDF_M (((TS_BRDF *)thebrdf)->m)
#define BRDF_N (((TS_BRDF *)thebrdf)->n)
#define BRDF_RS (((TS_BRDF *)thebrdf)->rs)
#define BRDF_RD (((TS_BRDF *)thebrdf)->rd)

#define HELP1 "This is the Cook-Torrance-Sparrow BRDF, using a"
#define HELP2 "Beckmann microfacet distribution function, Blinn's"
#define HELP3 "geometric shadowing term, and Fresnel reflection."
#define HELP4 "The parameters are the surface roughness m (as used"
#define HELP5 "in the Beckmann distribution), the index of refraction,"
#define HELP6 "and the diffuse and specular reflectivities."

static FD_ts_panel *fd_ts_panel;

void TS_panel_m_callback(FL_OBJECT *ob, long data)
{
	BRDF_M = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void TS_panel_n_callback(FL_OBJECT *ob, long data)
{
	if (data == 0)
		BRDF_N = BRDF_COMPLEX(fl_get_slider_value(ob),imag(BRDF_N));
	else
		BRDF_N = BRDF_COMPLEX(real(BRDF_N),fl_get_slider_value(ob));
	BRDFchanged = TRUE;
}

void TS_panel_rs_callback(FL_OBJECT *ob, long data)
{
	BRDF_RS = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void TS_panel_rd_callback(FL_OBJECT *ob, long data)
{
	BRDF_RD = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *ts_panel_init()
{
	fd_ts_panel = create_form_ts_panel();

	fl_set_slider_return(fd_ts_panel->TS_panel_m, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ts_panel->TS_panel_m, 0.01, 2.0);
	fl_set_slider_value(fd_ts_panel->TS_panel_m, BRDF_M);
	fl_set_slider_return(fd_ts_panel->TS_panel_nreal, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ts_panel->TS_panel_nreal, 1.0, 5.0);
	fl_set_slider_value(fd_ts_panel->TS_panel_nreal, real(BRDF_N));
	fl_set_slider_return(fd_ts_panel->TS_panel_nimag, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ts_panel->TS_panel_nimag, -2.0, 0.0);
	fl_set_slider_value(fd_ts_panel->TS_panel_nimag, imag(BRDF_N));
	fl_set_slider_return(fd_ts_panel->TS_panel_rs, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ts_panel->TS_panel_rs, 0, 1);
	fl_set_slider_value(fd_ts_panel->TS_panel_rs, BRDF_RS);
	fl_set_slider_return(fd_ts_panel->TS_panel_rd, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ts_panel->TS_panel_rd, 0, 1);
	fl_set_slider_value(fd_ts_panel->TS_panel_rd, BRDF_RD);

	fl_add_browser_line(fd_ts_panel->Helptext,HELP1);
	fl_add_browser_line(fd_ts_panel->Helptext,HELP2);
	fl_add_browser_line(fd_ts_panel->Helptext,HELP3);
	fl_add_browser_line(fd_ts_panel->Helptext,HELP4);
	fl_add_browser_line(fd_ts_panel->Helptext,HELP5);
	fl_add_browser_line(fd_ts_panel->Helptext,HELP6);

	return fd_ts_panel->ts_panel;
}
