/*
Szymon Rusinkiewicz

strauss_panel1.cc
The panel for the Strauss BRDF.
It works together with strauss_panel.c, which is generated automatically by
fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_strauss.h"

extern "C" {
#include "strauss_panel.h"
}

#define BRDF_S (((Strauss_BRDF *)thebrdf)->s)
#define BRDF_M (((Strauss_BRDF *)thebrdf)->m)
#define BRDF_KS (((Strauss_BRDF *)thebrdf)->ks)
#define BRDF_KD (((Strauss_BRDF *)thebrdf)->kd)

#define HELP1 "The Strauss model is a true empirical BRDF. It is based"
#define HELP2 "on the Phong illumination model, but \"repackages\" the"
#define HELP3 "parameters in terms of user-friendly variables. In"
#define HELP4 "addition, it contains simple approximations to Fresnel"
#define HELP5 "reflection and geometric shadowing terms."

static FD_strauss_panel *fd_strauss_panel;

void Strauss_panel_s_callback(FL_OBJECT *ob, long data)
{
	BRDF_S = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Strauss_panel_m_callback(FL_OBJECT *ob, long data)
{
	BRDF_M = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Strauss_panel_ks_callback(FL_OBJECT *ob, long data)
{
	BRDF_KS = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Strauss_panel_kd_callback(FL_OBJECT *ob, long data)
{
	BRDF_KD = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *strauss_panel_init()
{
	fd_strauss_panel = create_form_strauss_panel();

	fl_set_slider_return(fd_strauss_panel->Strauss_panel_s, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_strauss_panel->Strauss_panel_s, 0, 1);
	fl_set_slider_value(fd_strauss_panel->Strauss_panel_s, BRDF_S);
	fl_set_slider_return(fd_strauss_panel->Strauss_panel_m, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_strauss_panel->Strauss_panel_m, 0, 1);
	fl_set_slider_value(fd_strauss_panel->Strauss_panel_m, BRDF_M);
	fl_set_slider_return(fd_strauss_panel->Strauss_panel_ks, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_strauss_panel->Strauss_panel_ks, 0, 1);
	fl_set_slider_value(fd_strauss_panel->Strauss_panel_ks, BRDF_KS);
	fl_set_slider_return(fd_strauss_panel->Strauss_panel_kd, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_strauss_panel->Strauss_panel_kd, 0, 1);
	fl_set_slider_value(fd_strauss_panel->Strauss_panel_kd, BRDF_KD);
	
	fl_add_browser_line(fd_strauss_panel->Helptext,HELP1);
	fl_add_browser_line(fd_strauss_panel->Helptext,HELP2);
	fl_add_browser_line(fd_strauss_panel->Helptext,HELP3);
	fl_add_browser_line(fd_strauss_panel->Helptext,HELP4);
	fl_add_browser_line(fd_strauss_panel->Helptext,HELP5);

	return fd_strauss_panel->strauss_panel;
}
