/*
Szymon Rusinkiewicz

phong_panel1.cc
The panel for the Phonglike BRDFs.
It works together with phong_panel.c, which is generated automatically by
fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_phong.h"

extern "C" {
#include "phong_panel.h"
}

#define BRDF_N (((Phong_BRDF *)thebrdf)->n)
#define BRDF_KS (((Phong_BRDF *)thebrdf)->ks)
#define BRDF_KD (((Phong_BRDF *)thebrdf)->kd)
#define BRDF_Flags (((Phong_BRDF *)thebrdf)->Phong_Flags)

#define HELP1 "The Phong illumination model remains extremely"
#define HELP2 "popular despite its physical implausibility."
#define HELP3 "Lewis 94 defined a modified Phong-like BRDF"
#define HELP4 "that obeys reciprocity and integrates correctly."
#define HELP5 "Note that the diffuse and specular multipliers"
#define HELP6 "have different meanings in the original and"
#define HELP7 "models. Also implemented here are the Phong"
#define HELP8 "BRDFs using N dot H instead of R dot V."
#define HELP9 " "
#define HELP10 "The Schlick BRDF was designed to reduce the"
#define HELP11 "cost of computing the Phong function by replacing"
#define HELP12 "the cos^n function by a simpler one."

static FD_phong_panel *fd_phong_panel;

void Phong_panel_n_callback(FL_OBJECT *ob, long data)
{
	BRDF_N = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Phong_panel_ks_callback(FL_OBJECT *ob, long data)
{
	BRDF_KS = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Phong_panel_kd_callback(FL_OBJECT *ob, long data)
{
	BRDF_KD = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Phong_panel_Phong_callback(FL_OBJECT *ob, long data)
{
	if (data)
		BRDF_Flags |= PHONG_SCHLICK;
	else
		BRDF_Flags &= (~PHONG_SCHLICK);
	BRDFchanged = TRUE;
}

void Phong_panel_RV_callback(FL_OBJECT *ob, long data)
{
	if (data)
		BRDF_Flags |= PHONG_NH;
	else
		BRDF_Flags &= (~PHONG_NH);
	BRDFchanged = TRUE;
}

void Phong_panel_orig_callback(FL_OBJECT *ob, long data)
{
	if (data)
		BRDF_Flags |= PHONG_NEW;
	else
		BRDF_Flags &= (~PHONG_NEW);
	BRDFchanged = TRUE;
}


FL_FORM *phong_panel_init()
{
	fd_phong_panel = create_form_phong_panel();

	fl_set_slider_return(fd_phong_panel->Phong_panel_n, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_phong_panel->Phong_panel_n, 1, 1000);
	fl_set_slider_value(fd_phong_panel->Phong_panel_n, BRDF_N);
	fl_set_slider_return(fd_phong_panel->Phong_panel_ks, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_phong_panel->Phong_panel_ks, 0, 1);
	fl_set_slider_value(fd_phong_panel->Phong_panel_ks, BRDF_KS);
	fl_set_slider_return(fd_phong_panel->Phong_panel_kd, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_phong_panel->Phong_panel_kd, 0, 1);
	fl_set_slider_value(fd_phong_panel->Phong_panel_kd, BRDF_KD);
	
	fl_set_button(fd_phong_panel->Phong_panel_Phong,!(BRDF_Flags&PHONG_SCHLICK));
	fl_set_button(fd_phong_panel->Phong_panel_Schlick,!!(BRDF_Flags&PHONG_SCHLICK));
	fl_set_button(fd_phong_panel->Phong_panel_RV,!(BRDF_Flags&PHONG_NH));
	fl_set_button(fd_phong_panel->Phong_panel_NH,!!(BRDF_Flags&PHONG_NH));
	fl_set_button(fd_phong_panel->Phong_panel_orig,!(BRDF_Flags&PHONG_NEW));
	fl_set_button(fd_phong_panel->Phong_panel_new,!!(BRDF_Flags&PHONG_NEW));

	fl_add_browser_line(fd_phong_panel->Helptext,HELP1);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP2);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP3);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP4);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP5);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP6);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP7);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP8);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP9);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP10);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP11);
	fl_add_browser_line(fd_phong_panel->Helptext,HELP12);

	return fd_phong_panel->phong_panel;
}
