/*
Szymon Rusinkiewicz

on_panel1.cc
The panel for the Oren-Nayar BRDF.
It works together with on_panel.c, which is generated automatically by fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_on.h"

extern "C" {
#include "on_panel.h"
}

#define BRDF_S (((ON_BRDF *)thebrdf)->s)
#define BRDF_R (((ON_BRDF *)thebrdf)->r)

#define HELP1 "This is the rough diffuse surface BRDF by Oren"
#define HELP2 "and Nayar. It uses essentially the same microgeometry"
#define HELP3 "as the Torrance-Sparrow model, but assumes that"
#define HELP4 "the underlying surface is diffuse, rather than specular."
#define HELP5 "We implement the first approximation given in"
#define HELP6 "Oren and Nayar's paper, not the \"qualitative model\"."

static FD_on_panel *fd_on_panel;

void ON_panel_s_callback(FL_OBJECT *ob, long data)
{
	BRDF_S = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void ON_panel_r_callback(FL_OBJECT *ob, long data)
{
	BRDF_R = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *on_panel_init()
{
	fd_on_panel = create_form_on_panel();

	fl_set_slider_return(fd_on_panel->ON_panel_s, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_on_panel->ON_panel_s, 0.0, 1.0);
	fl_set_slider_value(fd_on_panel->ON_panel_s, BRDF_S);
	fl_set_slider_return(fd_on_panel->ON_panel_r, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_on_panel->ON_panel_r, 0.0, 1.0);
	fl_set_slider_value(fd_on_panel->ON_panel_r, BRDF_R);

	fl_add_browser_line(fd_on_panel->Helptext,HELP1);
	fl_add_browser_line(fd_on_panel->Helptext,HELP2);
	fl_add_browser_line(fd_on_panel->Helptext,HELP3);
	fl_add_browser_line(fd_on_panel->Helptext,HELP4);
	fl_add_browser_line(fd_on_panel->Helptext,HELP5);
	fl_add_browser_line(fd_on_panel->Helptext,HELP6);

	return fd_on_panel->on_panel;
}
