/*
Szymon Rusinkiewicz

minn_panel1.cc
The panel for the Minnaert BRDF.
It works together with minn_panel.c, which is generated automatically by
fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_minn.h"

extern "C" {
#include "minn_panel.h"
}

#define BRDF_K (((Minn_BRDF *)thebrdf)->k)

#define HELP1 "This is Minnaert's BRDF. It was an early attempt"
#define HELP2 "to fit an analytic BRDF to measured lunar reflectance."

static FD_minn_panel *fd_minn_panel;

void Minn_panel_k_callback(FL_OBJECT *ob, long data)
{
	BRDF_K = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *minn_panel_init()
{
	fd_minn_panel = create_form_minn_panel();

	fl_set_slider_return(fd_minn_panel->Minn_panel_k, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_minn_panel->Minn_panel_k, 0.0, 1.0);
	fl_set_slider_value(fd_minn_panel->Minn_panel_k, BRDF_K);

	fl_add_browser_line(fd_minn_panel->Helptext,HELP1);
	fl_add_browser_line(fd_minn_panel->Helptext,HELP2);

	return fd_minn_panel->minn_panel;
}
