/*
Szymon Rusinkiewicz

ls_panel1.cc
The panel for the Lommel-Seeliger BRDF.
It works together with ls_panel.c, which is generated automatically by fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_ls.h"

extern "C" {
#include "ls_panel.h"
}

#define BRDF_RV (((LS_BRDF *)thebrdf)->rv)

#define HELP1 "This is the Lommel-Seeliger Volumetric scattering BRDF."
#define HELP2 "It is a simple BRDF predicting scattering from a dusty"
#define HELP3 "surface. It ignores masking and shadowing."

static FD_ls_panel *fd_ls_panel;

void LS_panel_rv_callback(FL_OBJECT *ob, long data)
{
	BRDF_RV = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *ls_panel_init()
{
	fd_ls_panel = create_form_ls_panel();

	fl_set_slider_return(fd_ls_panel->LS_panel_rv, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_ls_panel->LS_panel_rv, 0.0, 1.0);
	fl_set_slider_value(fd_ls_panel->LS_panel_rv, BRDF_RV);

	fl_add_browser_line(fd_ls_panel->Helptext,HELP1);
	fl_add_browser_line(fd_ls_panel->Helptext,HELP2);
	fl_add_browser_line(fd_ls_panel->Helptext,HELP3);

	return fd_ls_panel->ls_panel;
}
