/*
Szymon Rusinkiewicz

htsg_panel1.cc
The panel for the He-Torrance-Sillon-Greenberg BRDF.
It works together with htsg_panel.c, which is generated automatically by
fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_htsg.h"

extern "C" {
#include "htsg_panel.h"
}

#define BRDF_S (((HTSG_BRDF *)thebrdf)->s)
#define BRDF_T (((HTSG_BRDF *)thebrdf)->t)
#define BRDF_N (((HTSG_BRDF *)thebrdf)->n)
#define BRDF_RS (((HTSG_BRDF *)thebrdf)->rs)
#define BRDF_RD (((HTSG_BRDF *)thebrdf)->rd)

#define HELP1 "This is the He-Torrance-Sillon-Greenberg BRDF. It is"
#define HELP2 "probably the most physically correct theoretically-"
#define HELP3 "based BRDF to date. It is based on a rough surface"
#define HELP4 "model that includes shadowing and masking (using the"
#define HELP5 "Smith formula), corrections for projected surface"
#define HELP6 "roughness, Fresnel reflection, and wave optics effects."
#define HELP7 "It also includes an ideal specular term, which is not"
#define HELP8 "modeled here. The surface parameters are sigma_0 (here"
#define HELP9 "normalized by dividing by wavelength) and tau. The"
#define HELP10 "average slope of the surface is proportional to the ratio"
#define HELP11 "of these two parameters, so varying them while keeping"
#define HELP12 "their ratio constant shows the effects of wave optics."

static FD_htsg_panel *fd_htsg_panel;

void HTSG_panel_s_callback(FL_OBJECT *ob, long data)
{
	BRDF_S = fl_get_slider_value(ob);
	BRDF_T = BRDF_S*fl_get_slider_value(fd_htsg_panel->HTSG_panel_t);
	BRDFchanged = TRUE;
}

void HTSG_panel_t_callback(FL_OBJECT *ob, long data)
{
	BRDF_T = fl_get_slider_value(ob) *
		 fl_get_slider_value(fd_htsg_panel->HTSG_panel_s);
	BRDFchanged = TRUE;
}

void HTSG_panel_n_callback(FL_OBJECT *ob, long data)
{
	if (data == 0)
		BRDF_N = BRDF_COMPLEX(fl_get_slider_value(ob),imag(BRDF_N));
	else
		BRDF_N = BRDF_COMPLEX(real(BRDF_N),fl_get_slider_value(ob));
	BRDFchanged = TRUE;
}

void HTSG_panel_rs_callback(FL_OBJECT *ob, long data)
{
	BRDF_RS = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void HTSG_panel_rd_callback(FL_OBJECT *ob, long data)
{
	BRDF_RD = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *htsg_panel_init()
{
	fd_htsg_panel = create_form_htsg_panel();

	fl_set_slider_return(fd_htsg_panel->HTSG_panel_s, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_htsg_panel->HTSG_panel_s, 0.1, 10);
	fl_set_slider_value(fd_htsg_panel->HTSG_panel_s, BRDF_S);
	fl_set_slider_return(fd_htsg_panel->HTSG_panel_t, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_htsg_panel->HTSG_panel_t, 0.1, 25);
	fl_set_slider_value(fd_htsg_panel->HTSG_panel_t, BRDF_T/BRDF_S);
	fl_set_slider_return(fd_htsg_panel->HTSG_panel_nreal, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_htsg_panel->HTSG_panel_nreal, 1.0, 5.0);
	fl_set_slider_value(fd_htsg_panel->HTSG_panel_nreal, real(BRDF_N));
	fl_set_slider_return(fd_htsg_panel->HTSG_panel_nimag, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_htsg_panel->HTSG_panel_nimag, -2.0, 0.0);
	fl_set_slider_value(fd_htsg_panel->HTSG_panel_nimag, imag(BRDF_N));
	fl_set_slider_return(fd_htsg_panel->HTSG_panel_rs, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_htsg_panel->HTSG_panel_rs, 0, 1);
	fl_set_slider_value(fd_htsg_panel->HTSG_panel_rs, BRDF_RS);
	fl_set_slider_return(fd_htsg_panel->HTSG_panel_rd, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_htsg_panel->HTSG_panel_rd, 0, 1);
	fl_set_slider_value(fd_htsg_panel->HTSG_panel_rd, BRDF_RD);

	fl_add_browser_line(fd_htsg_panel->Helptext,HELP1);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP2);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP3);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP4);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP5);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP6);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP7);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP8);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP9);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP10);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP11);
	fl_add_browser_line(fd_htsg_panel->Helptext,HELP12);

	return fd_htsg_panel->htsg_panel;
}
