/*
Szymon Rusinkiewicz

hls_panel1.cc
The panel for the Hapke/Lommel-Seeliger BRDF.
It works together with hls_panel.c, which is generated automatically by fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_hls.h"

extern "C" {
#include "hls_panel.h"
}

#define BRDF_G (((HLS_BRDF *)thebrdf)->g)
#define BRDF_F (((HLS_BRDF *)thebrdf)->f)
#define BRDF_R (((HLS_BRDF *)thebrdf)->r)

#define HELP1 "This is Bruce Hapke's theoretical lunar surface BRDF,"
#define HELP2 "incorporating Lommel-Seeliger scattering, Hapke's"
#define HELP3 "retrodirective function, Schoenberg backscattering,"
#define HELP4 "and a forward scattering term. It has been shown"
#define HELP5 "to agree quite well with measurements of the moon's"
#define HELP6 "surface. The surface parameter g varies with position"
#define HELP7 "on the moon, with an average of 0.6. The forward"
#define HELP8 "scattering parameter that agrees best with measured"
#define HELP9 "data is 0.1"

static FD_hls_panel *fd_hls_panel;

void HLS_panel_g_callback(FL_OBJECT *ob, long data)
{
	BRDF_G = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void HLS_panel_f_callback(FL_OBJECT *ob, long data)
{
	BRDF_F = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void HLS_panel_r_callback(FL_OBJECT *ob, long data)
{
	BRDF_R = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *hls_panel_init()
{
	fd_hls_panel = create_form_hls_panel();

	fl_set_slider_return(fd_hls_panel->HLS_panel_g, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_hls_panel->HLS_panel_g, 0.0, 1.0);
	fl_set_slider_value(fd_hls_panel->HLS_panel_g, BRDF_G);
	fl_set_slider_return(fd_hls_panel->HLS_panel_f, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_hls_panel->HLS_panel_f, 0.0, 1.0);
	fl_set_slider_value(fd_hls_panel->HLS_panel_f, BRDF_F);
	fl_set_slider_return(fd_hls_panel->HLS_panel_r, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_hls_panel->HLS_panel_r, 0.0, 1.0);
	fl_set_slider_value(fd_hls_panel->HLS_panel_r, BRDF_R);

	fl_add_browser_line(fd_hls_panel->Helptext,HELP1);
	fl_add_browser_line(fd_hls_panel->Helptext,HELP2);
	fl_add_browser_line(fd_hls_panel->Helptext,HELP3);
	fl_add_browser_line(fd_hls_panel->Helptext,HELP4);
	fl_add_browser_line(fd_hls_panel->Helptext,HELP5);
	fl_add_browser_line(fd_hls_panel->Helptext,HELP6);
	fl_add_browser_line(fd_hls_panel->Helptext,HELP7);
	fl_add_browser_line(fd_hls_panel->Helptext,HELP8);
	fl_add_browser_line(fd_hls_panel->Helptext,HELP9);

	return fd_hls_panel->hls_panel;
}
