/*
Szymon Rusinkiewicz

diffuse_panel1.cc
The panel for the Diffuse BRDF.
It works together with diffuse_panel.c, which is generated automatically by
fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_diffuse.h"

extern "C" {
#include "diffuse_panel.h"
}

#define BRDF_R (((Diffuse_BRDF *)thebrdf)->r)

#define HELP1 "This is the Lambertian diffuse BRDF. It is the simplest"
#define HELP2 "BRDF, and it is independent of the directions of"
#define HELP3 "incindence and reflection."

static FD_diffuse_panel *fd_diffuse_panel;

void Diffuse_panel_r_callback(FL_OBJECT *ob, long data)
{
	BRDF_R = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *diffuse_panel_init()
{
	fd_diffuse_panel = create_form_diffuse_panel();

	fl_set_slider_return(fd_diffuse_panel->Diffuse_panel_r, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_diffuse_panel->Diffuse_panel_r, 0.0, 1.0);
	fl_set_slider_value(fd_diffuse_panel->Diffuse_panel_r, BRDF_R);

	fl_add_browser_line(fd_diffuse_panel->Helptext,HELP1);
	fl_add_browser_line(fd_diffuse_panel->Helptext,HELP2);
	fl_add_browser_line(fd_diffuse_panel->Helptext,HELP3);

	return fd_diffuse_panel->diffuse_panel;
}
