/*
Szymon Rusinkiewicz

cyl_panel1.cc
The panel for the parallel cylinder BRDF.
It works together with cyl_panel.c, which is generated automatically by fdesign.

Note that we automatically replace thebrdf by a rotated BRDF, so that we can
provide rotation control in the panel. Yes, I *know* that's ugly...
*/

#include "bv_brdf_panels.h"
#include "brdf_cyl.h"
#include "brdf_rotate.h"

extern "C" {
#include "cyl_panel.h"
}

#define BRDF_D_UNROTATED (((Cyl_BRDF *)thebrdf)->d)
#define BRDF_H_UNROTATED (((Cyl_BRDF *)thebrdf)->h)
#define BRDF_N_UNROTATED (((Cyl_BRDF *)thebrdf)->n)
#define BRDF_RS_UNROTATED (((Cyl_BRDF *)thebrdf)->rs)
#define BRDF_RD_UNROTATED (((Cyl_BRDF *)thebrdf)->rd)
#define BRDF_D_ROTATED (((Cyl_BRDF *)(((Rotate_BRDF *)thebrdf)->b))->d)
#define BRDF_H_ROTATED (((Cyl_BRDF *)(((Rotate_BRDF *)thebrdf)->b))->h)
#define BRDF_N_ROTATED (((Cyl_BRDF *)(((Rotate_BRDF *)thebrdf)->b))->n)
#define BRDF_RS_ROTATED (((Cyl_BRDF *)(((Rotate_BRDF *)thebrdf)->b))->rs)
#define BRDF_RD_ROTATED (((Cyl_BRDF *)(((Rotate_BRDF *)thebrdf)->b))->rd)
#define BRDF_PHI (((Rotate_BRDF *)thebrdf)->phi)
#define BRDF_D BRDF_D_ROTATED
#define BRDF_H BRDF_H_ROTATED
#define BRDF_N BRDF_N_ROTATED
#define BRDF_RS BRDF_RS_ROTATED
#define BRDF_RD BRDF_RD_ROTATED

#define HELP1 "This is a BRDF that assumes a microgeometry of long,"
#define HELP2 "parallel cylinders. The cylinders are of radius 1, and"
#define HELP3 "may have arbitrary spacing. In addition, there is a floor"
#define HELP4 "between the cylinders. The material of which the cylinders"
#define HELP5 "and floor are made may have both diffuse and specular"
#define HELP6 "components."

static FD_cyl_panel *fd_cyl_panel;

void Cyl_panel_d_callback(FL_OBJECT *ob, long data)
{
	BRDF_D = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Cyl_panel_h_callback(FL_OBJECT *ob, long data)
{
	BRDF_H = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Cyl_panel_n_callback(FL_OBJECT *ob, long data)
{
	BRDF_N = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Cyl_panel_rs_callback(FL_OBJECT *ob, long data)
{
	BRDF_RS = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Cyl_panel_rd_callback(FL_OBJECT *ob, long data)
{
	BRDF_RD = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Cyl_rotation_callback(FL_OBJECT *ob, long data)
{
	float phi = fl_get_dial_value(ob);
	if (phi > 180)
		phi -= 360;
	BRDF_PHI = -deg2rad(phi);
	BRDFchanged = TRUE;
}


FL_FORM *cyl_panel_init()
{
	float oldd=BRDF_D_UNROTATED, oldh=BRDF_H_UNROTATED;
	float oldn=BRDF_N_UNROTATED;
	float oldrs=BRDF_RS_UNROTATED, oldrd=BRDF_RD_UNROTATED;
	delete thebrdf;
	char c[255];
	sprintf(c,"rotate %f cyl %f %f %f %f %f",0.0, oldd, oldh, oldn, oldrs, oldrd);
	thebrdf = BRDF::Create(c);

	fd_cyl_panel = create_form_cyl_panel();

	fl_set_slider_return(fd_cyl_panel->Cyl_panel_d, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_cyl_panel->Cyl_panel_d, 0, 10);
	fl_set_slider_value(fd_cyl_panel->Cyl_panel_d, BRDF_D);
	fl_set_slider_return(fd_cyl_panel->Cyl_panel_h, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_cyl_panel->Cyl_panel_h, 0.0, 1);
	fl_set_slider_value(fd_cyl_panel->Cyl_panel_h, BRDF_H);
	fl_set_slider_return(fd_cyl_panel->Cyl_panel_n, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_cyl_panel->Cyl_panel_n, 1, 1000);
	fl_set_slider_value(fd_cyl_panel->Cyl_panel_n, BRDF_N);
	fl_set_slider_return(fd_cyl_panel->Cyl_panel_rs, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_cyl_panel->Cyl_panel_rs, 0, 1);
	fl_set_slider_value(fd_cyl_panel->Cyl_panel_rs, BRDF_RS);
	fl_set_slider_return(fd_cyl_panel->Cyl_panel_rd, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_cyl_panel->Cyl_panel_rd, 0, 1);
	fl_set_slider_value(fd_cyl_panel->Cyl_panel_rd, BRDF_RD);

	fl_set_dial_cross(fd_cyl_panel->Cyl_rotation, TRUE);
	fl_set_dial_return(fd_cyl_panel->Cyl_rotation, BV_PANEL_RETURN);
	fl_set_dial_bounds(fd_cyl_panel->Cyl_rotation, 0, 360);
	fl_set_dial_value(fd_cyl_panel->Cyl_rotation, 0);

	fl_add_browser_line(fd_cyl_panel->Helptext,HELP1);
	fl_add_browser_line(fd_cyl_panel->Helptext,HELP2);
	fl_add_browser_line(fd_cyl_panel->Helptext,HELP3);
	fl_add_browser_line(fd_cyl_panel->Helptext,HELP4);
	fl_add_browser_line(fd_cyl_panel->Helptext,HELP5);
	fl_add_browser_line(fd_cyl_panel->Helptext,HELP6);

	return fd_cyl_panel->cyl_panel;
}
