/*
Szymon Rusinkiewicz

cos_panel1.cc
The panel for the generalized cosine lobe BRDF.
It works together with cos_panel.c, which is generated automatically by fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_cos.h"

extern "C" {
#include "cos_panel.h"
}

#define BRDF_CXY (((Cos_BRDF *)thebrdf)->cxy)
#define BRDF_CZ (((Cos_BRDF *)thebrdf)->cz)
#define BRDF_N (((Cos_BRDF *)thebrdf)->n)

#define HELP1 "This is Eric Lafortune's generalized cosine lobe model."
#define HELP2 "It is an empirical model that can represent off-specular"
#define HELP3 "reflection, non-Lambertian diffuse reflection, and"
#define HELP4 "retroreflection. Only the isotropic case is implemented"
#define HELP5 "here."


static FD_cos_panel *fd_cos_panel;

void Cos_panel_cxy_callback(FL_OBJECT *ob, long data)
{
	BRDF_CXY = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Cos_panel_cz_callback(FL_OBJECT *ob, long data)
{
	BRDF_CZ = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void Cos_panel_n_callback(FL_OBJECT *ob, long data)
{
	BRDF_N = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *cos_panel_init()
{
	fd_cos_panel = create_form_cos_panel();

	fl_set_slider_return(fd_cos_panel->Cos_panel_cxy, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_cos_panel->Cos_panel_cxy, -2, 2);
	fl_set_slider_value(fd_cos_panel->Cos_panel_cxy, BRDF_CXY);
	fl_set_slider_return(fd_cos_panel->Cos_panel_cz, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_cos_panel->Cos_panel_cz, 0, 2);
	fl_set_slider_value(fd_cos_panel->Cos_panel_cz, BRDF_CZ);
	fl_set_slider_return(fd_cos_panel->Cos_panel_n, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_cos_panel->Cos_panel_n, 1, 200);
	fl_set_slider_value(fd_cos_panel->Cos_panel_n, BRDF_N);
	
	fl_add_browser_line(fd_cos_panel->Helptext,HELP1);
	fl_add_browser_line(fd_cos_panel->Helptext,HELP2);
	fl_add_browser_line(fd_cos_panel->Helptext,HELP3);
	fl_add_browser_line(fd_cos_panel->Helptext,HELP4);
	fl_add_browser_line(fd_cos_panel->Helptext,HELP5);

	return fd_cos_panel->cos_panel;
}
