/*
Szymon Rusinkiewicz

bv_brdf_panels.cc
Panels with BRDF parameters, etc.
*/

#include <string.h>

#include "bv_brdf_panels.h"

typedef struct brdf_table_t {
	char *name;
	FL_FORM *(*init_panel)();
} brdf_table_t;

extern FL_FORM *diffuse_panel_init();
extern FL_FORM *ts_panel_init();
extern FL_FORM *bm_panel_init();
extern FL_FORM *on_panel_init();
extern FL_FORM *htsg_panel_init();
extern FL_FORM *ward_panel_init();
extern FL_FORM *cyl_panel_init();
extern FL_FORM *ls_panel_init();
extern FL_FORM *hls_panel_init();
extern FL_FORM *minn_panel_init();
extern FL_FORM *phong_panel_init();
extern FL_FORM *cos_panel_init();
extern FL_FORM *strauss_panel_init();

static brdf_table_t avail_brdf_panels[] = {

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                               BRDF table                                 //
//                                                                          //
//  Every BRDF with a panel must have an entry in this table.               //
//                                                                          //
	{"diffuse",diffuse_panel_init},
	{"ts",ts_panel_init},
	{"bm",bm_panel_init},
	{"on",on_panel_init},
	{"htsg",htsg_panel_init},
	{"ward",ward_panel_init},
	{"cyl",cyl_panel_init},
	{"ls",ls_panel_init},
	{"hls",hls_panel_init},
	{"minn",minn_panel_init},
	{"phong",phong_panel_init},
	{"schlick",phong_panel_init},
	{"cos",cos_panel_init},
	{"strauss",strauss_panel_init},
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

	{NULL,NULL}
};

/* Global */
BOOL BRDFchanged=FALSE;

/* Local */
static BOOL forminitialized=FALSE;

void init_brdf_panel(char *nameandparams)
{
	/* Get name out of nameandparams */
	if (!nameandparams || nameandparams[0] == '\0')
		return;
	char name[255]="",*c;
	if ((c=strstr(nameandparams," "))) {
		strncpy(name,nameandparams,c-nameandparams);
		name[c-nameandparams]='\0';
	} else {
		/* there are no parameters */
		strcpy(name,nameandparams);
	}

	/* Look for name in the table */
	brdf_table_t *p=avail_brdf_panels;
	for (;p->name;p++)
		if (strcasecmp(name,p->name) == 0)
			goto found; /* Dijkstra hates me */

	/* didn't find the name */
	return;

found:	/* p is pointing to the BRDF's struct in avail_brdfs */

	XFinit("BRDF Parameter panel");
	fl_show_form(p->init_panel(),FL_PLACE_SIZE,FL_FULLBORDER,"BRDF Parameter panel");
	forminitialized = TRUE;
	return;
}

void update_brdf_panel()
{
	if (!forminitialized)
		return;
	fl_check_forms();
}
