/*
Szymon Rusinkiewicz

bm_panel1.cc
The panel for the Beard-Maxwell BRDF.
It works together with bm_panel.c, which is generated automatically by fdesign.
*/

#include "bv_brdf_panels.h"
#include "brdf_bm.h"

extern "C" {
#include "bm_panel.h"
}

#define BRDF_OMEGA (((BM_BRDF *)thebrdf)->omega)
#define BRDF_TAU (((BM_BRDF *)thebrdf)->tau)
#define BRDF_N (((BM_BRDF *)thebrdf)->n)
#define BRDF_RS (((BM_BRDF *)thebrdf)->rs)
#define BRDF_RD (((BM_BRDF *)thebrdf)->rd)
#define BRDF_RV (((BM_BRDF *)thebrdf)->rv)

#define HELP1 "This is the Beard-Maxwell BRDF. It assumes a rough"
#define HELP2 "dielectric surface, and includes shadowing and Fresnel"
#define HELP3 "reflection terms. It also has diffuse and volumetric"
#define HELP4 "scattering terms to account for multiple surface and"
#define HELP5 "subsurface reflections."

static FD_bm_panel *fd_bm_panel;

void BM_panel_omega_callback(FL_OBJECT *ob, long data)
{
	BRDF_OMEGA = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void BM_panel_tau_callback(FL_OBJECT *ob, long data)
{
	BRDF_TAU = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void BM_panel_n_callback(FL_OBJECT *ob, long data)
{
	if (data == 0)
		BRDF_N = BRDF_COMPLEX(fl_get_slider_value(ob),imag(BRDF_N));
	else
		BRDF_N = BRDF_COMPLEX(real(BRDF_N),fl_get_slider_value(ob));
	BRDFchanged = TRUE;
}

void BM_panel_rs_callback(FL_OBJECT *ob, long data)
{
	BRDF_RS = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void BM_panel_rd_callback(FL_OBJECT *ob, long data)
{
	BRDF_RD = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}

void BM_panel_rv_callback(FL_OBJECT *ob, long data)
{
	BRDF_RV = fl_get_slider_value(ob);
	BRDFchanged = TRUE;
}


FL_FORM *bm_panel_init()
{
	fd_bm_panel = create_form_bm_panel();

	fl_set_slider_return(fd_bm_panel->BM_panel_omega, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_bm_panel->BM_panel_omega, 0.01, 2.0);
	fl_set_slider_value(fd_bm_panel->BM_panel_omega, BRDF_OMEGA);
	fl_set_slider_return(fd_bm_panel->BM_panel_tau, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_bm_panel->BM_panel_tau, 0.01, 2.0);
	fl_set_slider_value(fd_bm_panel->BM_panel_tau, BRDF_TAU);
	fl_set_slider_return(fd_bm_panel->BM_panel_nreal, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_bm_panel->BM_panel_nreal, 1.0, 5.0);
	fl_set_slider_value(fd_bm_panel->BM_panel_nreal, real(BRDF_N));
	fl_set_slider_return(fd_bm_panel->BM_panel_nimag, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_bm_panel->BM_panel_nimag, -2.0, 0.0);
	fl_set_slider_value(fd_bm_panel->BM_panel_nimag, imag(BRDF_N));
	fl_set_slider_return(fd_bm_panel->BM_panel_rs, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_bm_panel->BM_panel_rs, 0, 1);
	fl_set_slider_value(fd_bm_panel->BM_panel_rs, BRDF_RS);
	fl_set_slider_return(fd_bm_panel->BM_panel_rd, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_bm_panel->BM_panel_rd, 0, 1);
	fl_set_slider_value(fd_bm_panel->BM_panel_rd, BRDF_RD);
	fl_set_slider_return(fd_bm_panel->BM_panel_rv, BV_PANEL_RETURN);
	fl_set_slider_bounds(fd_bm_panel->BM_panel_rv, 0, 1);
	fl_set_slider_value(fd_bm_panel->BM_panel_rv, BRDF_RV);

	fl_add_browser_line(fd_bm_panel->Helptext,HELP1);
	fl_add_browser_line(fd_bm_panel->Helptext,HELP2);
	fl_add_browser_line(fd_bm_panel->Helptext,HELP3);
	fl_add_browser_line(fd_bm_panel->Helptext,HELP4);
	fl_add_browser_line(fd_bm_panel->Helptext,HELP5);

	return fd_bm_panel->bm_panel;
}
