#ifndef _SYS_DEPENDENT_H
#define _SYS_DEPENDENT_H

/*
Szymon Rusinkiewicz

sys_dependent.h
A few handy routines that may or may not exist on various systems.
*/

#include <unistd.h>

// Usleep
#ifdef sgi
#include <sys/time.h>
static inline void usleep(int x)
{
	struct timeval t;
	t.tv_sec = 0;
	t.tv_usec = x;
	select(0, 0, 0, 0, &t);
}

#else
#endif

// Yield the processor
#ifdef sgi
static inline void yield() { sginap(0); }
#else
#include <sched.h>
static inline void yield() { sched_yield(); }
#endif

#endif
