#ifndef _BV_SHM_H
#define _BV_SHM_H

/*
Szymon Rusinkiewicz

shm.h
The shared memory segment, and global variables that live there
*/

extern void shminit();
extern void shmdelete();
extern void *shmaddr;

#define cshmaddr ((char *)shmaddr)
#define SHM_DATA_SIZE 8
#define VAR_IN_SHM(_type,_offset) (*(_type *)(cshmaddr+SHM_DATA_SIZE*_offset))

/* What lives in the SHM segment */
#define bv_active VAR_IN_SHM(int,0)
#define lastrefresh VAR_IN_SHM(int,1)
#define brdf_in_x VAR_IN_SHM(float,2)
#define brdf_in_y VAR_IN_SHM(float,3)
#define usecos VAR_IN_SHM(usecos_options,6)
#define uselog VAR_IN_SHM(BOOL,7)
#define whichviewers VAR_IN_SHM(int,8)
#define def_top_window_x VAR_IN_SHM(int,9)
#define def_top_window_y VAR_IN_SHM(int,10)
#define bv_suggest_quit VAR_IN_SHM(int,11)

#endif
