/*
Szymon Rusinkiewicz

shm.cc
This just sets up a shared mem segment...
*/

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>

#include "bv.h"

/* The size of the shared memory segment - some systems don't like this
smaller than 1 page... */
#define SIZE 0x1000

/* Where the shared mem segment is mapped */
void *shmaddr;
/* The ID of the SHM segment */
static int id;

void sighandler(int);
void shmdelete();

void shminit()
{
	if ((id = shmget(0x1232123, 0, 0)) == -1) {
		id = shmget(0x1232123, SIZE, 0660|IPC_CREAT);
		shmaddr = shmat(id, 0, 0);
		memset(shmaddr, 0, SIZE);
	} else {
		shmaddr = shmat(id, 0, 0);
	}
	bv_active++;

	/* Make sure to clean up the shared mem segment, no matter how we die */

	atexit(shmdelete); /* atexit seems to be more portable than on_exit */

	// SYSV SHM silliness - we have to catch every possible way we can die
	// Otherwise, there is no reliable way to destroy the SHM segment
	signal(SIGHUP,sighandler);
	signal(SIGINT,sighandler);
	signal(SIGQUIT,sighandler);
	signal(SIGILL,sighandler);
	signal(SIGABRT,sighandler);
	signal(SIGFPE,sighandler);
	signal(SIGBUS,sighandler);
	signal(SIGSEGV,sighandler);
	signal(SIGTERM,sighandler);
}

void shmdelete()
{
	bv_active--;
	if (bv_active == 0)
		shmctl(id,IPC_RMID,NULL);
}

void sighandler(int sig)
{
	exit(1); /* atexit() should have registered a call to shmdelete() */
}
