/*
Szymon Rusinkiewicz

pick_brdf_main.cc
Pick a BRDF if one was not specified. This works with pick_brdf.c, which is
generated automatically by fdesign.
*/

#include <stdio.h>
#include <unistd.h>

#include "bv.h"
#include "bv_forms.h"

extern "C" {
#include "pick_brdf.h"
}

void PickBRDF(FL_OBJECT *ob, long data)
{
	int i=0;
	char s[255];

	switch(data) {
		case -999: exit(0);
		case 5:
		case 10:
		case 11: i=fl_get_menu(ob);
	}
	if (i == -1)
		return;
	switch(data) {
		case 0: sprintf(s,"diffuse"); break;
		case 1: sprintf(s,"ts"); break;
		case 2: sprintf(s,"bm"); break;
		case 3: sprintf(s,"on"); break;
		case 4: sprintf(s,"htsg"); break;
		case 5: switch(i) {
				case 1: sprintf(s,"ward 0.1 0.1"); break;
				case 2: sprintf(s,"ward 0.1 0.2"); break;
				case 3: sprintf(s,"ward 0.05 0.3"); break;
			}
			break;
		case 6: sprintf(s,"cyl"); break;
		case 7: sprintf(s,"ls"); break;
		case 8: sprintf(s,"hls"); break;
		case 9: sprintf(s,"minn"); break;
		case 10: switch(i) {
				case 1: sprintf(s,"phong 50 0.4 0.2 rv orig"); break;
				case 2: sprintf(s,"phong 200 0.4 0.2 nh orig"); break;
				case 3: sprintf(s,"phong 50 0.04 0.4 rv new"); break;
				case 4: sprintf(s,"phong 200 0.01 0.4 nh new"); break;
			}
			break;
		case 11: switch(i) {
				case 1: sprintf(s,"schlick 50 0.4 0.2 rv orig"); break;
				case 2: sprintf(s,"schlick 200 0.4 0.2 nh orig"); break;
				case 3: sprintf(s,"schlick 50 0.04 0.4 rv new"); break;
				case 4: sprintf(s,"schlick 200 0.01 0.4 nh new"); break;
			}
			break;
		case 12: sprintf(s,"cos"); break;
		case 13: sprintf(s,"strauss"); break;
		default: return;
	}
	bv_active--;
	execlp(myname,myname,s,NULL);
	bv_active++;
	exit(1);
}

void pick_brdf_main()
{
	FD_pick_brdf *fd_pick_brdf;

	XFinit("Pick a BRDF");
   	fd_pick_brdf = create_form_pick_brdf();

	fl_set_menu(fd_pick_brdf->Ward,"Isotropic|Slightly Anisotropic|Very Anisotropic");
	fl_set_menu(fd_pick_brdf->Phong,"Original - R dot V|Original - N dot H|Modified - R dot V|Modified - N dot H");
	fl_set_menu(fd_pick_brdf->Schlick,"Original - R dot V|Original - N dot H|Modified - R dot V|Modified - N dot H");

	/*
	fl_show_form(fd_pick_brdf->pick_brdf,FL_PLACE_MOUSE,FL_NOBORDER,"pick_brdf");
	*/
	fl_show_form(fd_pick_brdf->pick_brdf,FL_PLACE_MOUSE,FL_TRANSIENT,"pick_brdf");
	fl_do_forms();
	exit(1);
}
