/*
Szymon Rusinkiewicz

main.cc
Initialization routines...
*/

#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

#include "bv.h"
#include "bv_brdf_panels.h"

/* Global vars */
char myname[25] = "";
BRDF *thebrdf;


static void version()
{
	printf(	"Version %s, compiled %s\n",BV_VERSION,BV_COMPILED);
	printf(	" BRDFlib version %s, compiled %s\n",BRDFLIB_VERSION,BRDFLIB_COMPILED);
}

static void usage(BOOL printBRDFs)
{
	printf(	"Usage: %s [brdf [parameters]]\n\n",myname);
	printf( "Keys:\n"
		"      c               Cycle through options for multiplication\n"
		"                            by cos(theta in) or cos(theta out)\n"
		"      l               Toggle logarithm\n"
		"      Up, Down arrow  Increase, decrease gain\n" 
		"      s               Spin 3D view\n"
		"      r               Reset view to theta=0\n"
		"      n               New viewer\n"
		"      q               Quit\n"
		"\n"
		"Mouse Buttons:\n"
		"      left            Changes the angle of incoming light\n"
		"      middle          Changes viewing angle of 3-D view\n"
		"      right           Pop-up menu with many options\n"
		"\n"
		"Available viewers:\n"
		"       - 3D goniometric view\n"
		"       - 2D projections of the above (intensity is proportional to BRDF)\n"
		"       - Sphere with given BRDF, lit with moveable light source\n"
		"       - Lit Plane (just like lit sphere)\n"
	      );
	if (printBRDFs) {
		BRDF::Usage();
	} else {
		printf("\n%s -b lists available BRDFs\n",myname);
	}
}

int main(int argc, char *argv[])
{
	int i,c;
	BOOL dogui=FALSE;

	strcpy(myname,argv[0]);

	while ((c = getopt(argc, argv, "+vhbg")) != EOF)
		switch (c) {
			case 'h': version(); usage(FALSE); exit(0);
			case 'b': version(); usage(TRUE); exit(0);
			case 'v': version(); exit(0);
			case '?': usage(FALSE); exit(1);
			case 'g': dogui=TRUE; break;
		}

	char whichbrdf[255]="";
	if (argc > 1)
		strcat(whichbrdf,argv[1]);
	for (i=2;i<argc;i++) {
		strcat(whichbrdf," ");
		strcat(whichbrdf,argv[i]);
	}
	thebrdf = BRDF::Create(whichbrdf);

	// Fork off a separate process and return control right away.
	signal(SIGCHLD,SIG_IGN); /* Anti-zombie precautions */
	if (!fork()) {
		setsid();
#ifndef DEBUG
		fclose(stdin); fclose(stdout); fclose(stderr);
#endif
	} else {
		exit(0);
	}

	shminit();

	// Here's what we want to do:
	// If the shm segment didn't exist
	//   assume the GUI isn't running
	//   start it
	//   if a BRDF was specified
	//     start a viewer
	//   else
	//     exit
	// else
	//   assume the GUI is already running
	//   if a BRDF was specified
	//     start a viewer
	//   else
	//     fire up the BRDF picker

	if ((bv_active == 1) || dogui) {
		bv_active++;
		if (!fork())
			bv_gui_main();
		if (!thebrdf)
			exit(0);
	} else {
		if (!thebrdf)
			pick_brdf_main(); /* will exit */
	}

	init_brdf_panel(argv[1]);
	bv_main();

	exit(1); /* Can't happen */
}
