#ifndef _BV_GRAPHICS_H
#define _BV_GRAPHICS_H

/*
Szymon Rusinkiewicz

graphics.h
Defines an abstraction layer for the graphics routines.
*/

#define MOUSE_PRESS 0
#define MOUSE_DRAG 1
#define MOUSE_RELEASE 2

extern void GRinit(int *,char **);
extern void GRstart(char *);
extern void GRwindowtitle(char *);
extern void GRstartidle();
extern void GRstopidle();
extern void GRgetmouse(float *,float *);
extern void GRcommit();
extern int GRwin();
extern void GRsetwin(int);
extern BOOL GRIammapped();
extern void GRsetview2d(float scale = 1.0);
extern void GRsetview3d(float,float,float scale = 1.0);
extern void GRblackscreen();
extern void GRwhite();
extern void GRred();
extern void GRgreen();
extern void GRblue();
extern void GRyellow();
extern void GRpoint(float,float);
extern void GRpoint3(float,float,float);
extern void GRline(float,float,float,float);
extern void GRline3(float,float,float,float,float,float);
extern void GRdashedline(float,float,float,float);
extern void GRdashedline3(float,float,float,float,float,float);
extern void GRdrawpixmap(unsigned char *,int,int,float scale = 1.0);
extern void GRsurfaceplot(float[][3],int,int,float,float);
extern void GRlightsourcedir(float,float);

#endif
