#ifndef _BV_LIT_H
#define _BV_LIT_H

/*
Szymon Rusinkiewicz

bv_lit.h
This viewer presents either a sphere or a plane with the given BRDF, and a
user-moveable light source.
*/

#include "bv.h"

#pragma interface

class Viewer_Lit : public Viewer {
protected:
	unsigned char *litpixmap;
	virtual void compute_lit_pixmap(float,float) =0;
public:
	Viewer_Lit(const int res) : Viewer(res)
		{
			litpixmap = new unsigned char[SQR(res)];
		}
	virtual ~Viewer_Lit() {
		delete litpixmap;
	}

	virtual void redraw() =0;
	virtual BOOL update_mouse(float,float,int,int);
	virtual void changeres(int) =0;
};

class Viewer_LitPlane : public Viewer_Lit {
	typedef float ptype[2];
	ptype *pixmapangles;
	void initpixmapangles();
	virtual void compute_lit_pixmap(float,float);
public:
	Viewer_LitPlane(const int res) : Viewer_Lit(res)
		{
			pixmapangles = new ptype[SQR(res)];
			initpixmapangles();
		}
	virtual ~Viewer_LitPlane() {
		delete pixmapangles;
	}
	virtual void redraw();
	virtual void changeres(int res) {
		delete litpixmap;
		delete pixmapangles;
		resolution=res;
		litpixmap = new unsigned char[SQR(res)];
		pixmapangles = new ptype[SQR(res)];
		initpixmapangles();
	}
};

class Viewer_LitSphere : public Viewer_Lit {
	typedef float ptype[11];
	ptype *pixmapangles;
	void initpixmapangles();
	virtual void compute_lit_pixmap(float,float);
public:
	Viewer_LitSphere(const int res) : Viewer_Lit(res)
		{
			pixmapangles = new ptype[SQR(res)];
			initpixmapangles();
		}
	virtual ~Viewer_LitSphere() {
		delete pixmapangles;
	}
	virtual void redraw();
	virtual void changeres(int res) {
		delete litpixmap;
		delete pixmapangles;
		resolution=res;
		litpixmap = new unsigned char[SQR(res)];
		pixmapangles = new ptype[SQR(res)];
		initpixmapangles();
	}
};

#endif
