/*
Szymon Rusinkiewicz

bv_lit.cc
Code for a lit sphere with given BRDF
*/

#pragma implementation
#include "bv_lit.h"

#include "graphics.h"

void Viewer_LitSphere::initpixmapangles()
{
	int i,j;
	float x,y;

	for (j=0;j<resolution;j++)
	  for (i=0;i<resolution;i++) {
		x=((float)i+0.5)/resolution*2.0-1.0;
		y=((float)j+0.5)/resolution*2.0-1.0;
		if (SQR(x)+SQR(y) < 1.0) {
			float x1,y1,z1; /* Normal */
			float x2,y2,z2; /* Tangent */
			float x3,y3,z3; /* Their cross product */
			x1=x; y1=y; z1=sqrt(1.0-SQR(x)-SQR(y));
			y2=sqrt(SQR(x1)+SQR(z1));
			x2=-y1*x1/y2; z2=-y1*z1/y2;
			FindCrossProd(x1,y1,z1,x2,y2,z2,x3,y3,z3);
			pixmapangles[j*resolution+i][0]=acos(z1);
			pixmapangles[j*resolution+i][1]=atan2(z3,z2);
			pixmapangles[j*resolution+i][2]=x1;
			pixmapangles[j*resolution+i][3]=y1;
			pixmapangles[j*resolution+i][4]=z1;
			pixmapangles[j*resolution+i][5]=x2;
			pixmapangles[j*resolution+i][6]=y2;
			pixmapangles[j*resolution+i][7]=z2;
			pixmapangles[j*resolution+i][8]=x3;
			pixmapangles[j*resolution+i][9]=y3;
			pixmapangles[j*resolution+i][10]=z3;
		} else {
			pixmapangles[j*resolution+i][0]=-999;
		}
	}
}

void Viewer_LitSphere::compute_lit_pixmap(float theta, float phi)
{
	int i;
	float b;

	float xin=sin(theta)*cos(phi);
	float yin=sin(theta)*sin(phi);
	float zin=cos(theta);
	for (i=0;i<SQR(resolution);i++) {
		if (pixmapangles[i][0] == -999)
			litpixmap[i] = 0;
		else {
			float thetain=acos(xin*pixmapangles[i][2]+
					   yin*pixmapangles[i][3]+
					   zin*pixmapangles[i][4]);
			float phiin=atan2(xin*pixmapangles[i][8]+
					  yin*pixmapangles[i][9]+
					  zin*pixmapangles[i][10],
					  xin*pixmapangles[i][5]+
					  yin*pixmapangles[i][6]+
					  zin*pixmapangles[i][7]);
			if ((thetain > PI/2-EPS) || (pixmapangles[i][0] > PI/2-EPS)) {
				b=0.0;
			} else {
				b=thebrdf->Eval(thetain, phiin,
				  	pixmapangles[i][0], pixmapangles[i][1]);
				b=CLAMP(MODIFY_LOG(b*brightness*cos(thetain)),0.0,1.0-EPS);
			}
			litpixmap[i] = (unsigned char)(b*256);
		}
	}
}

void Viewer_LitPlane::initpixmapangles()
{
	int i,j;
	float x,y;

	for (j=0;j<resolution;j++)
	  for (i=0;i<resolution;i++) {
		x=((float)i+0.5)/resolution*2.0-1.0;
		y=((float)j+0.5)/resolution*2.0-1.0;
		if (y < -EPS) {
			float ox = -x;
			float oy = -1.0;
			float oz = -y;
			Normalize(ox,oy,oz);
			pixmapangles[j*resolution+i][0]=compute_theta(ox,oy);
			pixmapangles[j*resolution+i][1]=compute_phi(ox,oy);
		} else {
			pixmapangles[j*resolution+i][0]=-999;
		}
	}
}

void Viewer_LitPlane::compute_lit_pixmap(float theta, float phi)
{
	int i;
	float b;

	for (i=0;i<SQR(resolution);i++) {
		if (pixmapangles[i][0] == -999)
			litpixmap[i] = 0;
		else {
			b=thebrdf->Eval(theta, phi,
				  	pixmapangles[i][0], pixmapangles[i][1]);
			b=CLAMP(MODIFY_LOG(b*brightness*cos(theta)),0.0,1.0-EPS);
			litpixmap[i] = (unsigned char)(b*256);
		}
	}
}

BOOL Viewer_Lit::update_mouse(float mx, float my,
				int whichbutton, int button_press)
{
	if (button_press == MOUSE_RELEASE)
		return FALSE;
	if (whichbutton != 1)
		return FALSE;
	clamp_to_circle(mx,my);
	brdf_in_x = mx; brdf_in_y = my;
	return TRUE;
}

void Viewer_LitSphere::redraw()
{
	float th=2.0*compute_theta(brdf_in_x,brdf_in_y);
	float ph=compute_phi(brdf_in_x,brdf_in_y);

	GRsetview2d(1.2);
	GRblackscreen();
	compute_lit_pixmap(th,ph);
	GRdrawpixmap(litpixmap,resolution,resolution,1.2);
	GRlightsourcedir(th,ph);
}

void Viewer_LitPlane::redraw()
{
	float ix=brdf_in_x, iy=brdf_in_y;
	float th=compute_theta(ix,iy);
	float ph=compute_phi(ix,iy);
	float iz=sqrt(1.0-SQR(ix)-SQR(iy));
	float th1=compute_theta(ix,iz);
	float ph1=compute_phi(ix,iz);
	if (iy > 0)
		th1 = PI - th1;

	GRsetview2d();
	GRblackscreen();
	compute_lit_pixmap(th,ph);
	GRdrawpixmap(litpixmap,resolution,resolution);
	GRlightsourcedir(th1,ph1);
}

