/*
Szymon Rusinkiewicz

bv_gui_main.cc
A GUI with a few buttons. This works with the code in bv_gui.c, which is
generated automatically by fdesign.
*/

#include "sys_dependent.h"
#include "bv.h"
#include "bv_forms.h"

extern "C" {
#include "bv_gui.h"
}

static FD_bv_gui *fd_bv_gui;
static int mylastrefresh, mywhichviewers;

void update_buttons()
{
	fl_set_button(fd_bv_gui->Viewer1,!!(whichviewers & (1<<0)));
	fl_set_button(fd_bv_gui->Viewer2,!!(whichviewers & (1<<1)));
	fl_set_button(fd_bv_gui->Viewer3,!!(whichviewers & (1<<2)));
	fl_set_button(fd_bv_gui->Viewer4,!!(whichviewers & (1<<3)));
	fl_set_button(fd_bv_gui->Log,uselog);
	fl_set_button(fd_bv_gui->CosIn,usecos==USECOS_IN);
	fl_set_button(fd_bv_gui->CosOut,usecos==USECOS_OUT);
	fl_set_button(fd_bv_gui->CosProd,usecos==USECOS_PROD);
	fl_set_button(fd_bv_gui->CosSum,usecos==USECOS_SUM);
	mylastrefresh=lastrefresh;
	mywhichviewers=whichviewers;;
}

void Viewertoggle(FL_OBJECT *o, long i)
{
	whichviewers ^= (1<<(i-1));
}

void CosInToggle(FL_OBJECT *o, long i)
{
	if (usecos == USECOS_IN)
		usecos = USECOS_NONE;
	else
		usecos = USECOS_IN;
	update_buttons();
	lastrefresh++;
}

void CosOutToggle(FL_OBJECT *o, long i)
{
	if (usecos == USECOS_OUT)
		usecos = USECOS_NONE;
	else
		usecos = USECOS_OUT;
	update_buttons();
	lastrefresh++;
}

void CosProdToggle(FL_OBJECT *o, long i)
{
	if (usecos == USECOS_PROD)
		usecos = USECOS_NONE;
	else
		usecos = USECOS_PROD;
	update_buttons();
	lastrefresh++;
}

void CosSumToggle(FL_OBJECT *o, long i)
{
	if (usecos == USECOS_SUM)
		usecos = USECOS_NONE;
	else
		usecos = USECOS_SUM;
	update_buttons();
	lastrefresh++;
}

void Logtoggle(FL_OBJECT *o, long i)
{
	uselog = !uselog;
	lastrefresh++;
}

void DoNewBRDF(FL_OBJECT *o, long i)
{
	if (fork())
		return;
	execlp(myname,myname,NULL);
		// Whoops! something went wrong...
		// We need to fudge bv_active so it doesn't get decremented
		// too far (the call to exit will decrement it automagically)
	bv_active++;
	exit(1);
}

void DoQuit(FL_OBJECT *o, long i)
{
	bv_suggest_quit=TRUE;
	exit(0);
}

void bv_gui_main()
{
	XFinit("BV Options");
	fd_bv_gui = create_form_bv_gui();
	fl_show_form(fd_bv_gui->bv_gui,FL_PLACE_SIZE,FL_FULLBORDER,"BV Options");

	update_buttons();

	for(;;) {
		fl_check_forms();
		if ((mylastrefresh != lastrefresh) ||
		    (mywhichviewers != whichviewers))
			update_buttons();
		usleep(66666);
	}
}
