#ifndef _BV_3D_H
#define _BV_3D_H

/*
Szymon Rusinkiewicz

bv_3d.h
This is the "standard" 3-D goniometric view of a BRDF.
*/

#include "bv.h"

#pragma interface

class Viewer_3d : public Viewer {
	typedef float ptype[3];
	ptype *brdfs;
	typedef float qtype[5];
	qtype *angles;
	void initangles();
	void compute_brdfs(float,float);
public:
	Viewer_3d(const int res) : Viewer(res)
		{
			brdfs = new ptype[SQR(res)];
			angles = new qtype[SQR(res)];
			initangles();
		}

	virtual ~Viewer_3d() {
		delete brdfs;
		delete angles;
	}

	virtual void redraw();
	virtual BOOL update_mouse(float,float,int,int);
	virtual void changeres(int res) {
		delete brdfs;
		delete angles;
		resolution=res;
		brdfs = new ptype[SQR(res)];
		angles = new qtype[SQR(res)];
		initangles();
	}
	void spinviewer(int);
};

#endif
