#ifndef _BV_2D_H
#define _BV_2D_H

/*
Szymon Rusinkiewicz

bv_2d.h
This is a viewer where a two-dimensional slice of the BRDF is displayed as
intensity.
*/

#include "bv.h"

#pragma interface

class Viewer_2d : public Viewer {
	unsigned char *brdfpixmap;
	typedef float ptype[2];
	ptype *pixmapangles;
	void initpixmapangles();
	void compute_brdf_pixmap(float,float);
public:
	Viewer_2d(const int res) : Viewer(res)
	{
		brdfpixmap = new unsigned char[SQR(res)];
		pixmapangles = new ptype[SQR(res)];
		initpixmapangles();
	}

	virtual ~Viewer_2d()
	{
		delete brdfpixmap;
		delete pixmapangles;
	}

	virtual void redraw();
	virtual BOOL update_mouse(float,float,int,int);
	virtual void changeres(int res) {
		delete brdfpixmap;
		delete pixmapangles;
		resolution=res;
		brdfpixmap = new unsigned char[SQR(res)];
		pixmapangles = new ptype[SQR(res)];
		initpixmapangles();
	}
};

#endif
