/*
Szymon Rusinkiewicz

bv_2d.cc
Code for a 2-d projection of one slice of a BRDF.
*/

#pragma implementation
#include "bv_2d.h"

#include "graphics.h"

void Viewer_2d::initpixmapangles()
{
	int i,j;
	float x,y;

	for (j=0;j<resolution;j++)
	  for (i=0;i<resolution;i++) {
		x=((float)i+0.5)/resolution*2.0-1.0;
		y=((float)j+0.5)/resolution*2.0-1.0;
		if (SQR(x)+SQR(y) < 1.0) {
			pixmapangles[j*resolution+i][0]=compute_theta(x,y);
			pixmapangles[j*resolution+i][1]=compute_phi(x,y);
		} else {
			pixmapangles[j*resolution+i][0]=-999;
		}
	}
}

void Viewer_2d::compute_brdf_pixmap(float theta, float phi)
{
	int i,j;
	float b=0.0;

	for (i=0;i<SQR(resolution);i++) {
		if (pixmapangles[i][0] == -999)
			brdfpixmap[i] = 0;
		else {
			b = thebrdf->Eval(theta, phi,
					  pixmapangles[i][0], pixmapangles[i][1]);
			b = MODIFY_COS(b,theta,pixmapangles[i][0]);
			b = CLAMP(MODIFY_LOG(b*brightness),0.0,1-EPS);
			brdfpixmap[i] = (unsigned char)(b*256);
		}
	}
}

BOOL Viewer_2d::update_mouse(float mx, float my,
			    int whichbutton, int button_press)
{
	if (button_press == MOUSE_RELEASE)
		return FALSE;
	clamp_to_circle(mx,my);
	if (whichbutton == 1) {
		brdf_in_x = mx;
		brdf_in_y = my;
	}
	return TRUE;
}

void Viewer_2d::redraw()
{
	float ix=brdf_in_x, iy=brdf_in_y;

	GRsetview2d();
	GRblackscreen();

	compute_brdf_pixmap( compute_theta(ix,iy),
			     compute_phi(ix,iy) );

	GRdrawpixmap(brdfpixmap,resolution,resolution);
	/* Axes */
	GRwhite();
	GRline(-1,0,1,0);
	GRline(0,-1,0,1);
	/* Incoming angle */
	GRgreen();
	GRline(0,0,ix,iy);
	GRpoint(ix,iy);
	/* Angle of specular reflection */
	GRdashedline(0,0,-ix,-iy);
	GRpoint(-ix,-iy);
}

