/*
Szymon Rusinkiewicz

bv.cc
A BRDF browser. This file contains some of the initialization routines, and
most callbacks and event handlers.
*/

#include <unistd.h>

#pragma implementation
#include "bv.h"

#include "bv_2d.h"
#include "bv_3d.h"
#include "bv_lit.h"
#include "graphics.h"

/* Global vars */
int top_window_x, top_window_y;
int screenx, screeny; /* Per *subwindow* */
const int maxwindows=NUM_VIEWERS;
int numwindows=0;
float brightness=1.0;
BOOL spin3Dview=FALSE;

/* Local (to bv.cc) vars */
static int logbrightness=0;
static int resolution;
static Viewer *viewers[maxwindows];

/* When we are called, thebrdf has already been initialized, shminit has been
called, and the BRDF panels have been started. We just take care of the
per-window initialization. */

void bv_main()
{
	resolution=STARTING_RESOLUTION;

	top_window_x=def_top_window_x;
	top_window_y=def_top_window_y;
	if ((top_window_x == 0) || (top_window_y == 0)) {
		def_top_window_x=top_window_x=STARTING_SCREEN_X;
		def_top_window_y=top_window_y=STARTING_SCREEN_Y;
	}

	updateviewers(); /* Initialize the list of viewers */

	int argc=1; char *argv[]={myname};
	GRinit(&argc,argv);
	GRstart("BV");
}

void changetitle()
{
	char n[255];
	char c[255];

	thebrdf->Getname(n);
	sprintf(c,"%s [%c%c%c%1d]: %s",
			myname,
			usecos?'C':' ',
			uselog?'L':' ',
			logbrightness?(logbrightness>0?'+':'-'):' ',
			ABS(logbrightness),
			n
	);
	GRwindowtitle(c);
}

static Viewer *newViewer(int whichviewer)
{
	switch (whichviewer) {
		case 1:	return new Viewer_2d(resolution);
		case 2:	return new Viewer_3d(resolution);
		case 3:	return new Viewer_LitSphere(resolution);
		case 4:	return new Viewer_LitPlane(resolution);
		default: return NULL;
	}
}


/* Here are the callbacks... */

void updateviewers()
{
	int i;
	for (i=0;i<numwindows;i++)
		delete viewers[i];
	numwindows=0;
	if (whichviewers == 0)
		whichviewers = STARTING_VIEWERS;
	for (i=0;i<NUM_VIEWERS;i++)
		if (whichviewers & (1<<i))
			viewers[numwindows++] = newViewer(i+1);
	for (i=numwindows;i<maxwindows;i++)
		viewers[i] = NULL;
}

void refresh()
{
	if (!GRIammapped())
		return;

	int win=GRwin();
	if (win < 2)
		return;
	if (viewers[win-2]) {
		viewers[win-2]->redraw();
		GRcommit();
	}
}

void dospin(int recompute)
{
	if (!GRIammapped()) {
		spin3Dview=FALSE;
		return;
	}

	if (! (whichviewers & (1<<1))) {
		spin3Dview=FALSE;
		return;
	}

	int i=0;
	if (whichviewers&(1<<0))  i++;

	GRsetwin(i+2);
	((Viewer_3d *)viewers[i])->spinviewer(recompute);
}

BOOL updatemouse(int x, int y, int whichbutton, int button_press)
{
	int win=GRwin();
	if (win == 1)
		return FALSE;

	float mx=2.0*((float)x-(float)screenx/2.0)/(float)MIN(screenx,screeny);
	float my=-2.0*((float)y-(float)screeny/2.0)/(float)MIN(screenx,screeny);
	return viewers[win-2]->update_mouse(mx,my,whichbutton,button_press);
}

void changeres(int res)
{
	resolution=res;
	int i;
	for (i=0;i<numwindows;i++)
		viewers[i]->changeres(res);
}

void brighter()
{
	brightness*=SQRT2;
	logbrightness++;
}

void dimmer()
{
	brightness/=SQRT2;
	logbrightness--;
}

void togglelog()
{
	uselog = !uselog;
}

void togglecos()
{
	usecos=(usecos_options)((int)usecos+1);
	if (usecos == USECOS_INVALID)
		usecos = USECOS_NONE;
}

void togglespin3D()
{
	spin3Dview = !spin3Dview;
	if (spin3Dview)
		dospin(-1);
}

void resetview()
{
	brdf_in_x = brdf_in_y = 0;
}

void newviewer()
{
	if (!fork())
		execlp(myname,myname,NULL);
}

void cleanup()
{
	exit(0);
}
