#ifndef _FRESNEL_H
#define _FRESNEL_H

/*
Szymon Rusinkiewicz

fresnel.h
Fresnel reflection
*/

static inline BRDF_FLOAT Fresnel_term(BRDF_FLOAT c, BRDF_COMPLEX n)
{
	BRDF_COMPLEX g2=SQR(n)+SQR(c)-1.0;
	BRDF_FLOAT a=sqrt((abs(g2)+real(g2))/2.0);
	BRDF_FLOAT b=sqrt((abs(g2)-real(g2))/2.0);
	BRDF_FLOAT st=(1.0-SQR(c))/c;
	return 0.5*(SQR(a-c)+SQR(b))/(SQR(a+c)+SQR(b))*
		(1.0+(SQR(a-st)+SQR(b))/(SQR(a+st)+SQR(b)));
}

#endif
