/*
Szymon Rusinkiewicz

brdf_rotate.cc
Rotate an (anisotropic) BRDF about phi
*/

#pragma implementation
#include "brdf_rotate.h"

void Rotate_BRDF::Usage()
{
	printf(	"rotate      An arbitrary (anisotropic) BRDF rotated in phi\n"
		"            Parameters are: phi         Angle of rotation in degrees\n"
		"                            <brdf> [params...]\n"
	      );
}

BRDF *Rotate_BRDF::Create(const char *params)
{
	char *c;
	BRDF *b;
	float phi;
	
	if (sscanf(params,"%f",&phi) != 1)
		return NULL;

	if (!(c=strstr(params," ")))
		return NULL;

	b=BRDF::Create(c+1);
	if (!b)
		return NULL;

	// Degrees -> radians
	phi = deg2rad(phi);

	return new Rotate_BRDF(phi,b);
}

void Rotate_BRDF::Getname(char *nm)
{
	char nm1[255];

	b->Getname(nm1);
						// Radians -> degrees
	sprintf(nm,"(%s) rotated by %+04.0f",nm1,rad2deg(phi));
}

brdf_return_t Rotate_BRDF::Eval(BRDF_FLOAT theta_in, BRDF_FLOAT phi_in,
				BRDF_FLOAT theta_out, BRDF_FLOAT phi_out)
{
	return b->Eval(theta_in,phi_in+phi,theta_out,phi_out+phi);
}
