#ifndef _BRDF_PHONG_H
#define _BRDF_PHONG_H

/*
Szymon Rusinkiewicz

brdf_phong.h

The Schlick BRDF is just a hack of this, so it goes in the same file.
*/

#include "brdf.h"

#pragma interface

// Phong_Flags is made up of the following...
#define PHONG_RV (0<<0)
#define PHONG_NH (1<<0)
#define PHONG_ORIG (0<<1)
#define PHONG_NEW (1<<1)
#define PHONG_PHONG (0<<2)
#define PHONG_SCHLICK (1<<2)

class Phong_BRDF : public BRDF {
public:
	BRDF_FLOAT n;
	BRDF_FLOAT ks;
	BRDF_FLOAT kd;
	int Phong_Flags;
	Phong_BRDF(const BRDF_FLOAT _n,
		   const BRDF_FLOAT _ks,
		   const BRDF_FLOAT _kd,
		   const int _Phong_Flags) : n(_n), ks(_ks), kd(_kd),
		   			     Phong_Flags(_Phong_Flags) {}

	static void Usage();
	static BRDF *Create_Phonglike(const char *, int);
	static BRDF *Create(const char *params) {
		return Phong_BRDF::Create_Phonglike(params, PHONG_PHONG);
	}
	virtual void Getname(char *);
	virtual brdf_return_t Eval(BRDF_FLOAT,BRDF_FLOAT,BRDF_FLOAT,BRDF_FLOAT);
};

class Schlick_BRDF : public Phong_BRDF {
public:
	Schlick_BRDF(const BRDF_FLOAT _n,
		     const BRDF_FLOAT _ks,
		     const BRDF_FLOAT _kd,
		     const int _Phong_Flags) : Phong_BRDF(_n, _ks, _kd,
							  _Phong_Flags) {}
	static void Usage();
	static BRDF *Create(const char *params) {
		return Phong_BRDF::Create_Phonglike(params, PHONG_SCHLICK);
	}
};

#endif
