/*
Szymon Rusinkiewicz

brdf_minn.cc
Minnaert's "limb darkening" BRDF
*/

#pragma implementation
#include "brdf_minn.h"

void Minn_BRDF::Usage()
{
	printf( "minn        Minnaert's BRDF\n"
		"            Parameter is:   k [0.5]     \"Limb\" parameter\n" 
	      );
}

BRDF *Minn_BRDF::Create(const char *params)
{
	float k=0.5;
	
	if (params)
		sscanf(params,"%f",&k);

	return new Minn_BRDF(k);
}

void Minn_BRDF::Getname(char *nm)
{
	sprintf(nm,"Minnaert  k=%.2f",k);
}

brdf_return_t Minn_BRDF::Eval(BRDF_FLOAT theta_in, BRDF_FLOAT phi_in,
				 BRDF_FLOAT theta_out, BRDF_FLOAT phi_out)
{
	return (k+1)/2.0/PI*pow(MAX(cos(theta_in)*cos(theta_out),EPS),k-1.0);
}
