/*
Szymon Rusinkiewicz

brdf_ls.cc
Lommel-Seeliger Scattering
*/

#pragma implementation
#include "brdf_ls.h"

void LS_BRDF::Usage()
{
	printf( "ls          Lommel-Seeliger Scattering\n"
		"            Parameter is:   rv [0.4]    Volumetric scattering coefficient\n"
	      );
}

BRDF *LS_BRDF::Create(const char *params)
{
	float rv=0.4;
	
	if (params)
		sscanf(params,"%f",&rv);

	return new LS_BRDF(rv);
}

void LS_BRDF::Getname(char *nm)
{
	sprintf(nm,"Lommel-Seeliger Scattering  rv=%.2f",rv);
}

brdf_return_t LS_BRDF::Eval(BRDF_FLOAT theta_in, BRDF_FLOAT phi_in,
				 BRDF_FLOAT theta_out, BRDF_FLOAT phi_out)
{
	return 2.0*rv/MAX(cos(theta_in)+cos(theta_out),EPS);
}
