/*
Szymon Rusinkiewicz

brdf_diffuse.cc
Lambertian Diffuse BRDF

As simple as it gets...
*/

#pragma implementation
#include "brdf_diffuse.h"

void Diffuse_BRDF::Usage()
{
	printf( "diffuse     Lambertian diffuse BRDF\n"
		"            Parameter is:   r [1.0]     Total reflectivity\n" 
	      );
}

BRDF *Diffuse_BRDF::Create(const char *params)
{
	float r=1.0;
	
	if (params)
		sscanf(params,"%f",&r);

	return new Diffuse_BRDF(r);
}

void Diffuse_BRDF::Getname(char *nm)
{
	sprintf(nm,"Diffuse  r=%.2f",r);
}

brdf_return_t Diffuse_BRDF::Eval(BRDF_FLOAT theta_in, BRDF_FLOAT phi_in,
				 BRDF_FLOAT theta_out, BRDF_FLOAT phi_out)
{
	return (1.0/PI)*r;
}
