#ifndef _BRDF_BM_H
#define _BRDF_BM_H

/*
Szymon Rusinkiewicz

brdf_bm.h
*/

#include "brdf.h"

#pragma interface

class BM_BRDF : public BRDF {
public:
	BRDF_FLOAT omega;
	BRDF_FLOAT tau;
	BRDF_COMPLEX n;
	BRDF_FLOAT rs;
	BRDF_FLOAT rd;
	BRDF_FLOAT rv;
	BM_BRDF(const BRDF_FLOAT _omega,
		const BRDF_FLOAT _tau,
		const BRDF_FLOAT _nreal,
		const BRDF_FLOAT _nimag,
		const BRDF_FLOAT _rs,
		const BRDF_FLOAT _rd,
		const BRDF_FLOAT _rv) : omega(_omega), tau(_tau),
					n(_nreal,_nimag),
					rs(_rs), rd(_rd), rv(_rv) {}

	static void Usage();
	static BRDF *Create(const char *);
	virtual void Getname(char *);   
	virtual brdf_return_t Eval(BRDF_FLOAT,BRDF_FLOAT,BRDF_FLOAT,BRDF_FLOAT);
};

#endif
