#ifndef _BRDF_ARITH_H
#define _BRDF_ARITH_H

/*
Szymon Rusinkiewicz

brdf_arith.h
Basic arithmetic on BRDFs
*/

#include "brdf.h"

#pragma interface

typedef enum { ARITH_SUM, ARITH_SQDIFF, ARITH_ABSDIFF } Arith_ops;
static char *Arith_Name_Table[] = {
	"Sum",
	"Squared Difference",
	"Absolute Value of Difference",
};

class Arith_BRDF : public BRDF {
public:
	BRDF *b1;
	BRDF *b2;
	Arith_ops op;
	Arith_BRDF(BRDF *_b1,
		   BRDF *_b2,
		   const Arith_ops _op) : b1(_b1), b2(_b2), op(_op) {}
	virtual ~Arith_BRDF() { delete b1; delete b2; }

	static BRDF *Create_Arith(Arith_ops, const char *);
	virtual void Getname(char *);
	virtual brdf_return_t Eval(BRDF_FLOAT,BRDF_FLOAT,BRDF_FLOAT,BRDF_FLOAT);
};

class Sum_BRDF : public Arith_BRDF {
public:
	Sum_BRDF(BRDF *_b1,
		 BRDF *_b2) : Arith_BRDF(_b1, _b2, ARITH_SUM) {}

	static void Usage();
	static BRDF *Create(const char *params) {
		return Create_Arith(ARITH_SUM, params);
	}
};

class SqDiff_BRDF : public Arith_BRDF {
public:
	SqDiff_BRDF(BRDF *_b1,
		 BRDF *_b2) : Arith_BRDF(_b1, _b2, ARITH_SQDIFF) {}

	static void Usage();
	static BRDF *Create(const char *params) {
		return Create_Arith(ARITH_SQDIFF, params);
	}
};

class AbsDiff_BRDF : public Arith_BRDF {
public:
	AbsDiff_BRDF(BRDF *_b1,
		 BRDF *_b2) : Arith_BRDF(_b1, _b2, ARITH_ABSDIFF) {}

	static void Usage();
	static BRDF *Create(const char *params) {
		return Create_Arith(ARITH_ABSDIFF, params);
	}
};

#endif
