/*
Szymon Rusinkiewicz

brdf_arith.cc
Basic arithmetic on BRDFs
*/

#pragma implementation
#include "brdf_arith.h"

void Sum_BRDF::Usage()
{
	printf(	"sum         Sum of two BRDFs\n"
		"            Parameters are: <brdf1> [params1] , <brdf2> [params2]\n"
	      );
}

void SqDiff_BRDF::Usage()
{
	printf(	"sqdiff      Squared difference between two BRDFs\n"
		"            Parameters are: <brdf1> [params1] , <brdf2> [params2]\n"
	      );
}

void AbsDiff_BRDF::Usage()
{
	printf(	"absdiff     Absolute value of difference between two BRDFs\n"
		"            Parameters are: <brdf1> [params1] , <brdf2> [params2]\n"
	      );
}

BRDF *Arith_BRDF::Create_Arith(Arith_ops whichop, const char *params)
{
	char *c;
	char whichbrdf[255];
	BRDF *b1,*b2;
	
#ifdef DEBUG
	printf("arith_init: params=(%s)\n",params);
#endif
	/* First find the separator. */
	if (!(c=strstr(params," , ")))
		return NULL;

	/* Everything up to there is the first BRDF. */
	strncpy(whichbrdf,params,c-params);
	whichbrdf[c-params]='\0';
#ifdef DEBUG
	printf("arith_init: whichbrdf=(%s)\n",whichbrdf);
#endif

	if (!(b1=BRDF::Create(whichbrdf)))
		return NULL;

	/* OK, so we have one BRDF. Now get the other one. */
	if (!(b2=BRDF::Create(c+3))) {
		/* Something went wrong - we clean up and abort */
		delete b1;
		return NULL;
	}
	
	/* Got them both */
	return new Arith_BRDF(b1, b2, whichop);
}

void Arith_BRDF::Getname(char *nm)
{
	char nm1[255],nm2[255];

	b1->Getname(nm1);
	b2->Getname(nm2);
	sprintf(nm,"%s of (%s) and (%s)",Arith_Name_Table[op],nm1,nm2);
}

brdf_return_t Arith_BRDF::Eval(BRDF_FLOAT theta_in, BRDF_FLOAT phi_in,
			       BRDF_FLOAT theta_out, BRDF_FLOAT phi_out)
{
	brdf_return_t val1 = b1->Eval(theta_in,phi_in,theta_out,phi_out);
	brdf_return_t val2 = b2->Eval(theta_in,phi_in,theta_out,phi_out);

	switch(op) {
		case ARITH_SUM: return val1+val2;
		case ARITH_SQDIFF: return SQR(val1-val2);
		case ARITH_ABSDIFF: return ABS(val1-val2);
		default: return 0.0; // Yikes!
	}
}
