#ifndef _BRDF_H
#define _BRDF_H

/*
Szymon Rusinkiewicz

brdf.h
Routines defining an interface to the BRDF-computing functions
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "util.h"

#pragma interface

// Defining this means that passing NULL to init_brdf automatically uses the
// first BRDF in the table.
#undef BRDF_USE_DEFAULT

// This type is used for a lot of intermediate computations.
#define BRDF_FLOAT double
//#define BRDF_FLOAT float
#define BRDF_COMPLEX complex<BRDF_FLOAT>

// The type returned by the BRDF function
// When color is added, this will change...
typedef BRDF_FLOAT brdf_return_t;

// The BRDF abstract class
class BRDF {
public:
	// Print out available BRDFs and options
	static void Usage();

	// Create a new BRDF, given its name and options
	static BRDF *Create(const char *);

	// Returns the full name of the BRDF and options - overwrites the
	// string argument
	virtual void Getname(char *) =0;

	// Evaluate the BRDF at one incoming, outgoing angle
	virtual brdf_return_t Eval(BRDF_FLOAT,BRDF_FLOAT,BRDF_FLOAT,BRDF_FLOAT) =0;
};


/* From version.cc */

extern char *BRDFLIB_VERSION;
extern char *BRDFLIB_COMPILED;

#endif
