/*
Szymon Rusinkiewicz

brdf.cc
Implementation of brdf.h
*/

#include <string.h>

#pragma implementation
#include "brdf.h"

#include "brdf_arith.h"
#include "brdf_bm.h"
#include "brdf_cos.h"
#include "brdf_cyl.h"
#include "brdf_diffuse.h"
#include "brdf_hls.h"
#include "brdf_htsg.h"
#include "brdf_ls.h"
#include "brdf_minn.h"
#include "brdf_on.h"
#include "brdf_phong.h"
#include "brdf_rotate.h"
#include "brdf_strauss.h"
#include "brdf_ts.h"
#include "brdf_ward.h"

#define B(b) {	#b ,	     b ## _BRDF::Usage,  b ## _BRDF::Create }
static const struct brdf_table_t {
		char *name;  void (*usage)();    BRDF *(*constructor)(const char *);
} avail_brdfs[] = {

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                               BRDF table                                 //
//                                                                          //
// Each BRDF must have a line in this table. The include files defining the //
// necessary functions must be listed above.                                //
//                                                                          //

	B(Diffuse),
	B(TS),
	B(BM),
	B(ON),
	B(HTSG),
	B(Ward),
	B(Cyl),
	B(LS),
	B(HLS),
	B(Minn),
	B(Phong),
	B(Schlick),
	B(Cos),
	B(Strauss),
	B(Rotate),
	B(Sum),
	B(SqDiff),
	B(AbsDiff),
	B(Rotate),
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

	{NULL,NULL,NULL}
};
#undef B



/* Just print out the available BRDFs */
void BRDF::Usage()
{
	const brdf_table_t *p=avail_brdfs;

	printf(	"\nAvailable BRDFs:"
#ifdef BRDF_USE_DEFAULT
		" (first one is default)"
#endif
		"\n\n");

	for (;p->name;p++) {
		p->usage();
		printf("\n");
	}
}

/* Takes the name of the BRDF and the parameters, and returns a pointer
to the new BRDF object. Returns NULL on error. */
BRDF *BRDF::Create(const char *nameandparams)
{
	char name[255]="",params[255]="",*c;
	const brdf_table_t *p=avail_brdfs;

	if (!nameandparams || nameandparams[0] == '\0')
#ifdef BRDF_USE_DEFAULT
		/* If name is null, we just take the first one in the list */
		goto found;
#else
		/* If name is null, die. */
		return NULL;
#endif

	/* Try to split nameandparams into name and params */
	if ((c=strstr(nameandparams," "))) {
		strncpy(name,nameandparams,c-nameandparams);
		name[c-nameandparams]='\0';
		strcpy(params,c+1);
	} else {
		/* there are no parameters */
		strcpy(name,nameandparams);
	}

	/* OK, we have name and params split. Look for them in the table. */
	for (;p->name;p++)
		if (strcasecmp(name,p->name) == 0)
			goto found; /* Dijkstra hates me */

	/* didn't find the name */
	return NULL;


found:

	/* p is pointing to the BRDF's struct in avail_brdfs */
#ifdef DEBUG
	printf("init_brdf: found name=(%s), params=(%s)\n", p->name,params);
#endif
	return p->constructor(params);
}
