/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "__utilsource.h"

#include "wiregl/include/wiregl_util.h"

#include <stdio.h>
#include <ctype.h>

#ifndef WINDOWS
#include <errno.h>
#endif

static char *
EatWhiteSpace( char *buf )
{
	while ( *buf && isspace( *buf ) )
	{
		buf++;
	}
	return buf;
}

UTIL_DECL char *
wireGLGetLine( FILE *fp, char *buf )
{
	char buf2[1024], *temp;
	int len;

	do 
	{
		temp = fgets( buf2, sizeof(buf2)-1, fp );
		if ( feof( fp ) || !temp )
		{
			return NULL;
		}

		/* strip leading white space */
		temp = EatWhiteSpace( temp );

		/* strip trailing white space */
		len = strlen( temp );
		while ( len > 0 && isspace(temp[len-1]) ) {
			temp[--len] = '\0';
		}
			
	} while ( len == 0 || temp[0] == '#' );

	/* copy out the string we found */
	strcpy( buf, temp );

	return buf;
}

UTIL_DECL void
wireGLParseFile( char *filename, WireGLParseStruct *parsers )
{
	char buf[1024];
	FILE *fp = fopen( filename, "r" );
	if ( !fp )
	{
		wireGLSimpleError( "wireGLParseFile( \"%s\" ) : %s", 
						   filename, strerror( errno ) );
	}

	memset( buf, 0, sizeof(buf) );

	while ( wireGLGetLine( fp, buf ) != NULL )
	{
		WireGLParseStruct *ps;
		char *rest_of_line;
		rest_of_line = buf;
		while ( *rest_of_line && !isspace(*rest_of_line) )
		{
			rest_of_line++;
		}
		if ( *rest_of_line )
		{
			*rest_of_line = 0;
			rest_of_line = EatWhiteSpace( rest_of_line + 1 );
		}
		for (ps = parsers ; ps->str != NULL ; ps++)
		{
			if ( !strcmp( buf, ps->str ) )
			{
				ps->parser( rest_of_line );
				break;
			}
		}
		if ( !ps->str )
		{
			wireGLSimpleError( "wireGLParseFile( \"%s\" ): parse error: "
							   "key=%s val=%s", filename, buf, rest_of_line );
		}
	}

	fclose( fp );
}
