/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "__utilsource.h"

#include "wiregl/include/wiregl_util.h"
#include <stdlib.h>

#ifdef USE_DMALLOC
#include <dmalloc.h>
#endif

UTIL_DECL void *
wireGLAlloc( unsigned int bytes )
{
	void *ret;
#ifdef USE_DMALLOC
	static int first = 1;

	if ( first )
	{
		unsigned int flags;
		dmalloc_message( "wireGL -- first alloc call "
						 "(turning on error_abort)\n" );
		flags = dmalloc_debug_current( );
		flags |= 0x400000;
		dmalloc_debug( flags );
		first = 0;
	}
#endif

	ret = malloc( bytes );
	if ( ret == NULL )
	{
		wireGLError( "Couldn't allocate %d bytes!", bytes );
	}

	return ret;
}

UTIL_DECL void 
wireGLRealloc( void **ptr_ptr, unsigned int bytes )
{
	void *ptr = *ptr_ptr;
	if ( ptr == NULL )
	{
		ptr = wireGLAlloc( bytes );
	}
	else 
	{
		ptr = realloc( ptr, bytes );
		if ( !ptr )
		{
			wireGLError( "Couldn't reallocate %d bytes!", bytes );
		}
	}

	*ptr_ptr = ptr;
}

UTIL_DECL void 
wireGLFree( void *ptr )
{
	if ( ptr )
	{
		free( ptr );
	}
}
