/* Matrix4x4AdjointTranspose
 * -------------------------
 * Calculates the adjoint transpose of a matrix. Since this transformation takes
 * place in homogenous coordinates, it is identical to taking the inverse of the
 * matrix. Takes in a double matrix in GL order, finds its adjoint transpose,
 * and stores it in the location pointed to by inv.
 *
 * Credit to Matthew Eldridge for the code.
 */

static __inline void
__gl_Matrix4x4AdjointInverse( GLmatrix *adj_trans,
                                const GLmatrix *mat )
{
    GLfloat m00 = mat->m00;
    GLfloat m01 = mat->m01;
    GLfloat m02 = mat->m02;
    GLfloat m03 = mat->m03;

    GLfloat m10 = mat->m10;
    GLfloat m11 = mat->m11;
    GLfloat m12 = mat->m12;
    GLfloat m13 = mat->m13;
    
	GLfloat m20 = mat->m20;
    GLfloat m21 = mat->m21;
    GLfloat m22 = mat->m22;
    GLfloat m23 = mat->m23;

    GLfloat m30 = mat->m30;
    GLfloat m31 = mat->m31;
    GLfloat m32 = mat->m32;
    GLfloat m33 = mat->m33;

#define det3x3(a1, a2, a3, b1, b2, b3, c1, c2, c3) \
(a1 * (b2 * c3 - b3 * c2) + \
 b1 * (c2 * a3 - a2 * c3) + \
 c1 * (a2 * b3 - a3 * b2))

    GLfloat cof00 = det3x3( m11, m12, m13,
                             m21, m22, m23,
                             m31, m32, m33 );

    GLfloat cof01 = -det3x3( m12, m13, m10,
                              m22, m23, m20,
                              m32, m33, m30 );

    GLfloat cof02 = det3x3( m13, m10, m11,
                             m23, m20, m21,
                             m33, m30, m31 );

    GLfloat cof03 = -det3x3( m10, m11, m12,
                              m20, m21, m22,
                              m30, m31, m32 );


    GLfloat cof10 = -det3x3( m21, m22, m23,
                              m31, m32, m33,
                              m01, m02, m03 );

    GLfloat cof11 = det3x3( m22, m23, m20,
                             m32, m33, m30,
                             m02, m03, m00 );

    GLfloat cof12 = -det3x3( m23, m20, m21,
                              m33, m30, m31,
                              m03, m00, m01 );

    GLfloat cof13 = det3x3( m20, m21, m22,
                             m30, m31, m32,
                             m00, m01, m02 );


    GLfloat cof20 = det3x3( m31, m32, m33,
                             m01, m02, m03,
                             m11, m12, m13 );

    GLfloat cof21 = -det3x3( m32, m33, m30,
                              m02, m03, m00,
                              m12, m13, m10 );

    GLfloat cof22 = det3x3( m33, m30, m31,
                             m03, m00, m01,
                             m13, m10, m11 );

    GLfloat cof23 = -det3x3( m30, m31, m32,
                              m00, m01, m02,
                              m10, m11, m12 );


    GLfloat cof30 = -det3x3( m01, m02, m03,
                              m11, m12, m13,
                              m21, m22, m23 );

    GLfloat cof31 = det3x3( m02, m03, m00,
                             m12, m13, m10,
                             m22, m23, m20 );

    GLfloat cof32 = -det3x3( m03, m00, m01,
                              m13, m10, m11,
                              m23, m20, m21 );

    GLfloat cof33 = det3x3( m00, m01, m02,
                             m10, m11, m12,
                             m20, m21, m22 );

#undef det3x3


    adj_trans->m00 = cof00;
    adj_trans->m10 = cof01;
    adj_trans->m20 = cof02;
    adj_trans->m30 = cof03;

    adj_trans->m01 = cof10;
    adj_trans->m11 = cof11;
    adj_trans->m21 = cof12;
    adj_trans->m31 = cof13;

    adj_trans->m02 = cof20;
    adj_trans->m12 = cof21;    
	adj_trans->m22 = cof22;
    adj_trans->m32 = cof23;

    adj_trans->m03 = cof30;
    adj_trans->m13 = cof31;
    adj_trans->m23 = cof32;
    adj_trans->m33 = cof33;
}
