/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "__utilsource.h"

#include "wiregl/include/wiregl_util.h"

#if defined(IRIX) || defined(IRIX64) || defined(Linux) || defined(AIX)
#include <dlfcn.h>
#endif

UTIL_DECL WireGLDSO *wireGLDSOOpen( const char *dllname )
{
	WireGLDSO *dso;
	
	dso = (WireGLDSO *) wireGLAlloc( sizeof( WireGLDSO ) );
	dso->dllname = (char *) wireGLAlloc( strlen(dllname) + 1 );
	strcpy( dso->dllname, dllname );

#if defined(WINDOWS)
	dso->hinstLib = LoadLibrary( dllname );
#elif defined(IRIX) || defined(IRIX64) || defined(Linux) || defined(AIX)
	dso->hinstLib = dlopen( dllname, RTLD_NOW /* RTLD_LAZY */ );
#else
#error DSO
#endif

	if (!dso->hinstLib)
	{
		wireGLSimpleError( "DSO Loader couldn't find %s", dllname );
	}
	return dso;
}

UTIL_DECL WireGLDSOFunc wireGLDSOGetNoError( WireGLDSO *dso, const char *symname )
{
#if defined(WINDOWS)
	return (WireGLDSOFunc) GetProcAddress( dso->hinstLib, symname );
#elif defined(IRIX) || defined(IRIX64) || defined(Linux) || defined(AIX)
	return (WireGLDSOFunc) dlsym( dso->hinstLib, symname );
#else
#error DSO
#endif
}

UTIL_DECL WireGLDSOFunc wireGLDSOGet( WireGLDSO *dso, const char *symname )
{
	WireGLDSOFunc data = wireGLDSOGetNoError( dso, symname );
	if (!data)
	{
		wireGLSimpleError( "Couldn't get symbol \"%s\" in \"%s\".  Are you "
						   "sure there isn't some C++ mangling messing you "
						   "up?", symname, dso->dllname );
	}
	return data;
}

UTIL_DECL void wireGLDSOClose( WireGLDSO *dso )
{
#if defined(WINDOWS)
	FreeLibrary( dso->hinstLib );
#elif defined(IRIX) || defined(IRIX64) || defined(Linux) || defined(AIX)
	dlclose( dso->hinstLib );
#else
#error DSO
#endif
	wireGLFree( dso->dllname );
	wireGLFree( dso );
}
