/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "__utilsource.h"

#include "wiregl/include/wiregl_util.h"

void
wireGLBufferPoolInit( WireGLBufferPool *pool, unsigned int max )
{
    pool->num = 0;
    pool->max = max;
    pool->buf = (void **) wireGLAlloc( pool->max * sizeof(pool->buf[0]) );
}

static void
wireGLBufferPoolGrow( WireGLBufferPool *pool, unsigned int count )
{
	if ( count > pool->max )
	{
		unsigned int n_bytes;
		while ( count > pool->max )
			pool->max <<= 1;
		n_bytes = pool->max * sizeof(pool->buf[0]);
		wireGLRealloc( (void **) &pool->buf, n_bytes );
	}
}

void
wireGLBufferPoolLoad( WireGLBufferPool *pool, void *mem, unsigned int stride,
					  unsigned int count )
{
	unsigned int   i;
	unsigned char *buf;

	wireGLBufferPoolGrow( pool, pool->num + count );

	buf = (unsigned char *) mem;
	for ( i = 0; i < count; i++ )
	{
		pool->buf[ pool->num++ ] = buf;
		buf += stride;
	}
}

void
wireGLBufferPoolPush( WireGLBufferPool *pool, void *buf )
{
    if ( pool->num == pool->max )
		wireGLBufferPoolGrow( pool, pool->num + 1 );

    pool->buf[ pool->num++ ] = buf;
}

void *
wireGLBufferPoolPop( WireGLBufferPool *pool )
{
	void *buf = NULL;

    if ( pool->num )
        buf = pool->buf[ --pool->num ];

	return buf;
}
