# voxel.pl

binmode STDOUT;

@corners = ( [ 0, 1, 0 ],
             [ 0, 1, 1 ],
             [ 0, 0, 1 ],
             [ 0, 0, 0 ],
             [ 1, 1, 0 ],
             [ 1, 1, 1 ],
             [ 1, 0, 1 ],
             [ 1, 0, 0 ] );

@edges = ( [ 1, 0 ],
           [ 1, 2 ],
           [ 2, 3 ],
           [ 0, 3 ],
           [ 5, 4 ],
           [ 5, 6 ],
           [ 6, 7 ],
           [ 4, 7 ],
           [ 4, 0 ],
           [ 5, 1 ],
           [ 7, 3 ],
           [ 6, 2 ] );

$submit_floats = 1;

sub Index() {

  my ( $i ) = @_;
  my @x = @{$corners[$i]};
  my $str = "base";

  $str .= " + slice_skip"  if ( $x[2] );
  $str .= " + row_skip" if ( $x[1] );
  $str .= " + 1"     if ( $x[0] );

  return $str;
}

sub Emit() {

  my ( $parallel ) = @_;

  print <<EOF;
/* voxel.h -- auto-generated by voxel.pl */

typedef struct normal_t {
    float i, j, k;
} normal_t;

static int
DoVoxel( VolumeChunk *chunk, int i, int j, int k )
{
    int   row_skip, slice_skip;
    int   base, i0, i1, i2, i3, i4, i5, i6, i7, index, e;
    u8    den0, den1, den2, den3, den4, den5, den6, den7;
    const int *edges;
    float alpha;
    normal_t normal[8];
EOF

  if ( $submit_floats ) {
    print "    GLfloat vertex[12][3];\n";
    print "    GLfloat edge_normal[12][3];\n";
  }
  else {
    print "    GLshort vertex[12][3];\n";
    print "    GLbyte  edge_normal[12][3];\n";
    print "    float   mag, inv_mag;\n";
  }

print <<EOF;
    float nx, ny, nz;
    float vx, vy, vz;
    u8    threshold = globals.threshold;
    int   triangles = 0;
    u8   *density;

    density    = chunk->density;
    row_skip   = chunk->row_skip;
    slice_skip = chunk->slice_skip;

    assert( i >= 0 && i < chunk->w &&
            j >= 0 && j < chunk->h &&
            k >= 0 && k < chunk->d );

    base = k * slice_skip + j * row_skip + i;

EOF

  for ( $i = 0; $i < 8; $i++ ) {
    printf "    i%d   = %s;\n", $i, &Index($i);
    printf "    den%d = density[i%d];\n", $i, $i;
    print  "    {\n";
    printf "        int d1 = density[i%d-1];\n", $i;
    printf "        int d2 = density[i%d+1];\n", $i;
    printf "        int d3 = density[i%d-row_skip];\n", $i;
    printf "        int d4 = density[i%d+row_skip];\n", $i;
    printf "        int d5 = density[i%d-slice_skip];\n", $i;
    printf "        int d6 = density[i%d+slice_skip];\n", $i;
    print  "        int nx = d1 - d2;\n";
    print  "        int ny = d3 - d4;\n";
    print  "        int nz = d5 - d6;\n";
    print  "        if ( nx || ny || nz )\n";
    print  "        {\n";
    print  "        	float m2 = (float) ( nx * nx + ny * ny + nz * nz );\n";
    print  "        	float im = 1.0f / (float) sqrt( m2 );\n";
    printf "        	normal[%d].i = (float) nx * im;\n", $i;
    printf "        	normal[%d].j = (float) ny * im;\n", $i;
    printf "        	normal[%d].k = (float) nz * im;\n", $i;
    print  "        }\n";
    print  "        else\n";
    print  "        {\n";
    printf "        	normal[%d].i = 0.0f;\n", $i;
    printf "        	normal[%d].j = 0.0f;\n", $i;
    printf "        	normal[%d].k = 0.0f;\n", $i;
    print  "        }\n";
    print  "    }\n";
    printf "\n";
  }
  
  printf "    index  = ( den0 > threshold );\n";
  for ( $i = 1; $i < 8; $i++ ) {
    print "    index |= ( den${i} > threshold ) << ${i};\n";
  }
  
  print "\n";
  print "    if ( index == 0 || index == 0xff ) return 0;\n";
  print "\n";

  print "    i += chunk->i0;\n";
  print "    j += chunk->j0;\n";
  print "    k += chunk->k0;\n";
  print "\n";

  print "    e = edgeTable[index];\n";
  
  for ( $i = 0; $i < 12; $i++ ) {
  
    printf "    if ( e & 0x%x ) {\n", ( 1 << $i  );
    printf "        assert( den%d != den%d );\n", $edges[$i][0], $edges[$i][1];
    printf "        alpha = (threshold - den%d) / (float) (den%d - den%d);\n", $edges[$i][1], $edges[$i][0], $edges[$i][1];
    @c0 = @{$corners[$edges[$i][0]]};
    @c1 = @{$corners[$edges[$i][1]]};
  #  printf "        printf( \"alpha=%%.3f\\n\", alpha );\n";
  
    if ( $c0[0] == $c1[0] ) {
      printf "        vx = i + %s;\n", $c0[0];
    } else {
      printf "        vx = i + %s;\n", !$c0[0] ? "1 - alpha" : "alpha";
    }

    if ( $c0[1] == $c1[1] ) {
      printf "        vy = j + %s;\n", $c0[1];
    } else {
      printf "        vy = j + %s;\n", !$c0[1] ? "1 - alpha" : "alpha";
    }

    if ( $c0[2] == $c1[2] ) {
      printf "        vz = k + %s;\n", $c0[2];
    } else {
      printf "        vz = k + %s;\n", !$c0[2] ? "1 - alpha" : "alpha";
    }

    if ( $submit_floats ) {
      print "        vertex[$i][0] = vx;\n";
      print "        vertex[$i][1] = vy;\n";
      print "        vertex[$i][2] = vz;\n";
    }
    else {
      print "        vertex[$i][0] = (GLshort) ( vx * 64.0f );\n";
      print "        vertex[$i][1] = (GLshort) ( vy * 64.0f );\n";
      print "        vertex[$i][2] = (GLshort) ( vz * 64.0f );\n";
    }

    printf "        nx = (1.0f - alpha) * normal[%d].i + alpha * normal[%d].i;\n", $edges[$i][1], $edges[$i][0];

    printf "        ny = (1.0f - alpha) * normal[%d].j + alpha * normal[%d].j;\n", $edges[$i][1], $edges[$i][0];

    printf "        nz = (1.0f - alpha) * normal[%d].k + alpha * normal[%d].k;\n", $edges[$i][1], $edges[$i][0];

    if ( $submit_floats ) {
      if ( 0 ) {
	printf "        mag = nx * nx + ny * ny + nz * nz;\n";
	printf "        inv_mag = 1.0f / SquareRoot( mag );\n";
	printf "        edge_normal[$i][0] = nx * inv_mag;\n";
	printf "        edge_normal[$i][1] = ny * inv_mag;\n";
	printf "        edge_normal[$i][2] = nz * inv_mag;\n";
      } else { 
	printf "        edge_normal[$i][0] = nx;\n";
	printf "        edge_normal[$i][1] = ny;\n";
	printf "        edge_normal[$i][2] = nz;\n";
      }
    }
    else {
      printf "        mag = nx * nx + ny * ny + nz * nz;\n";
      printf "        inv_mag = 127.0f / SquareRoot( mag );\n";
      printf "        edge_normal[$i][0] = (GLbyte) ( nx * inv_mag );\n";
      printf "        edge_normal[$i][1] = (GLbyte) ( ny * inv_mag );\n";
      printf "        edge_normal[$i][2] = (GLbyte) ( nz * inv_mag );\n";
    }

    printf "    }\n\n";
  }

    my $glNormal = "glNormal3bv";
    my $glVertex = "glVertex3sv";
    if ( $submit_floats ) {
      $glNormal = "glNormal3fv";
      $glVertex = "glVertex3fv";
    }
    
print <<EOF;
    edges = triCases[index];
    while ( *edges != -1 ) {
        ${glNormal}( edge_normal[*edges] );
        ${glVertex}( vertex[*edges] );
        edges++;
        ${glNormal}( edge_normal[*edges] );
        ${glVertex}( vertex[*edges] );
        edges++;
        ${glNormal}( edge_normal[*edges] );
        ${glVertex}( vertex[*edges] );
        edges++;

       triangles++;
    }

    return triangles;
}
EOF
}  

&Emit( );
