/* volume.h */

#ifndef VOLUME_H
#define VOLUME_H

#include "misc.h"

typedef struct {
    u8 min;
    u8 max;
} VolumeMinMax;

typedef struct {
    u32 offset;
    u8  i, j, k, step;
} VolumeTraversalOrder;

typedef struct VolumeChunk {
    int           i0, j0, k0;  /* source position */
    int           i_idx, j_idx, k_idx;  /* chunk number */
    int           w, h, d;     /* dimensions */
    int           row_skip;    /* row-to-row step */
    int           slice_skip;  /* slice-to-slice step */
    u8           *density;
    VolumeMinMax *minmax;
    VolumeTraversalOrder **accelOrder;
    u8            min_density;
    u8            max_density;
    int           doneFlag;
} VolumeChunk;

typedef struct Volume {
    int           width, height, depth;
    u8           *density;
    int           i_chunks;
    int           j_chunks;
    int           k_chunks;
	int           num_chunks;
    VolumeChunk  *chunk;
    VolumeTraversalOrder **chunkOrder;
} Volume;

/* volread.c */
int  Volume_MakeSphere( u32 dim, Volume *volume );
int  Volume_MakeCube( u32 dim, Volume *volume );
int  Volume_MakePointField( u32 dim, Volume *volume );
int  Volume_ReadRaw( const char *name, u32 w, u32 h, u32 d, Volume *volume );
int  Volume_ReadDen( const char *name, Volume *volume );

/* volcrunch.c */
void Volume_SubSample( Volume *src, u32 factor, Volume *dst );
void Volume_Pad( Volume *volume, int width, int height, int depth );
void Volume_Chunk( Volume *volume, int chunk_w, int chunk_h, int chunk_d );

#endif
