/* track.h */

#ifndef TRACK_H
#define TRACK_H

typedef struct {
    float i, j, k;
} V3;

typedef union {
    V3    v;
    float q[4];
} Quat;

V3    vzero( void );
V3    vset( float i, float j, float k );
V3    vsub( V3 a, V3 b );
V3    vcross( V3 a, V3 b );
float vdot( V3 a, V3 b );
float vlength( V3 v );
V3    vscale( V3 v, float m );
V3    vnormal( V3 v );
V3    vadd( V3 a, V3 b );
V3    rotVector( float m[4][4], V3 a );

Quat  axisToQuat( V3 axis, float phi );
Quat  trackball( float p1x, float p1y, float p2x, float p2y, float radius );
Quat  addQuats( Quat q1, Quat q2 );
void  quatToMatrix( Quat quat, float m[4][4] );


#endif
