/* misc.h */

#ifndef MISC_H
#define MISC_H

typedef unsigned char  u8;
typedef unsigned short u16;
typedef unsigned int   u32;

typedef signed char    s8;
typedef signed short   s16;
typedef signed int     s32;

#ifdef WINDOWS
#define SquareRoot(x) sqrt(x)
#else
#define SquareRoot(x) sqrtf(x)
#endif

#define ABS(x)          (((x) > 0) ? (x) : -(x))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define NELEMS(x)       ((sizeof(x)) / (sizeof((x)[0])))

#define CHECK_OGL_ERROR()     CheckOglError( __FILE__, __LINE__ )
void CheckOglError( const char *file, int line );

void *xmalloc( size_t size );
void  xfree( void *ptr );
void  xfatal( const char *format, ... );

#endif
