/* globals.h */

#ifndef GLOBALS_H
#define GLOBALS_H

#include "misc.h"
#include "track.h"
#include "volume.h"

typedef struct {
    Quat  quat;
    float radius;
    V3    up;
    V3    look;
} Viewer;

typedef enum { OrderNone, OrderPartial, OrderTotal, OrderBarrier } WorkOrder;

typedef struct {
    u32         threshold;
    float       opacity;
    WorkOrder   sequence_chunks;
    u32         rainbow;
	u32         depth_buffer;
    u32         cull_enable;
	u32         wireframe;
    Viewer      camera;
	u32         exit;
} FrameParam;

typedef struct {
    struct {
        int w;
        int h;
    } win;
    int         single_buffer;
    int         idle_rotate;
	int         thread_id;
    int         num_threads;
    Volume      volume;
    int         verbose;
    u32         threshold;
    float       opacity;
    WorkOrder   sequence_chunks;
    u32         rainbow;
	u32         depth_buffer;
    u32         cull_enable;
	u32         wireframe;
    Viewer      camera;
	int         chunk_index;
	int         use_gui;
	u32         print;
	u32         malloc_bytes;
	u32         passes;
	int         please_exit;
	float       measure_time;
	int         spin;
	int         bbox_hint;
} Globals;

extern Globals globals;

#endif
