/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <GL/gl.h>

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_pipe.h"
#include "wiregl/include/wiregl_util.h"

/* HACK - these is defined in stream.c */
extern WireGLConnection *current_conn;
extern WireGLWorkQueue *__currentQueue;

void 
__decodeWriteback( void )
{
	WireGLWorkQueue	       *queue = __currentQueue;
	WireGLConnection       *conn = current_conn;
	void                   *buf  = wireGLNetAlloc( conn );
	WireGLMessageWriteback *msg  = (WireGLMessageWriteback *) buf;

#if 0
	wireGLWarning( WIREGL_WARN_DEBUG, "Sending writeback" );
#endif

	msg->type = WIREGL_MESSAGE_WRITEBACK;

	INCR_DATA_PTR_NO_ARGS( );

	if ( queue->peer_conn )
	{
		/* one more outstanding writeback to wait for */
		queue->peer_conn->pending_writebacks++;

		while ( queue->peer_conn->pending_writebacks > 0 )
		{
			wireGLNetRecv( );
		}
	}

	wireGLNetSend( conn, &buf, msg, sizeof(*msg) );
}
