/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <GL/gl.h>

#include <stdio.h>
#include <stdlib.h>

typedef struct{
	unsigned short	firstEntry,
					colorMapLenght;
	unsigned char	colorMapEntrySize;
}ColorMap;

typedef struct{
	unsigned short	xOrigin,
					yOrigin,
					width,
					height;
	unsigned char	bpp,
					imageDescriptor;
}ImageSpec;


static unsigned short	fgetShort	( FILE *imageStream )
{
	unsigned short temp;
	
	temp = (unsigned short) fgetc ( imageStream );
	temp |= fgetc ( imageStream ) << 8;
	
	return temp;
}


static void	myswap	( unsigned char *one, unsigned char *two )
{
	unsigned char	three;
	
	three = *one;
	*one = *two;
	*two = three;
}

void	wireGLLoadTARGATexture	( char *filename )
{
	FILE			*imageStream = NULL;
	unsigned char	*image = NULL;
	unsigned short	width,
					height;
	unsigned char	bpp;
	int i;
	
	imageStream = fopen ( filename, "rb" );
	if( imageStream == 0 )
	{
		fprintf( stderr, "Couldn't open texture \"%s\".\n", filename );
		return;
	}
	
	fgetc ( imageStream );		// ID Length
	fgetc ( imageStream );		// Color Map Type
	fgetc ( imageStream );		// Image Type
	
	fgetShort ( imageStream );	// First Entry
	fgetShort ( imageStream );	// Color Map Length
	fgetc ( imageStream );		// Color Map Entry Size
	
	fgetShort ( imageStream );	// X Origin
	fgetShort ( imageStream );	// Y Origin
	width = fgetShort ( imageStream );
	height = fgetShort ( imageStream );
	bpp = (unsigned char) fgetc ( imageStream );
	fgetc ( imageStream );		// Image Descriptor
	
	if ( bpp != 32 && bpp != 24 && bpp != 8 )
	{
		fprintf( stderr, "Image \"%s\" has unwanted bitdepth of %d.\n", filename, bpp );
		fclose( imageStream );
		return;
	}
	
	image = (unsigned char *) malloc( sizeof(unsigned char) * width * height * ( bpp >> 3 ));
	if ( image == NULL )
	{
		fprintf( stderr, "Not enough mem to allocate texture named \"%s\".\n", filename );
		fclose( imageStream );
		return;
	}
	
	if ( bpp == 32 )
	{
		for ( i = 0; i < width * height * 4; i++ )
		{
			image [i] = (unsigned char) fgetc ( imageStream );
		}
		for ( i = 0; i < width * height; i++ )
		{
			myswap(( image + i*4 + 0 ), ( image + i*4 + 2 ));
		}
	}
	else if ( bpp == 24 )
	{
		for ( i = 0; i < width * height * 3; i++ )
		{
			image [i] = (unsigned char) fgetc ( imageStream );
		}
		for ( i = 0; i < width * height; i++ )
		{
			myswap(( image + i*3 + 0 ), ( image + i*3 + 2 ));
		}
	}
	else // bpp == 8
	{
		fread( image, height * width, 1, imageStream );
	}
	
	/* I don't care about the rest, close the file and return */
	if ( fclose ( imageStream ) == EOF )
	{
		fprintf( stderr, "Error closing stream to \"%s\".\n", filename );
	}
	
	if ( bpp == 32 )
		glTexImage2D ( GL_TEXTURE_2D, 0, GL_RGBA, width, height,
						0, GL_RGBA, GL_UNSIGNED_BYTE, image );
	else if ( bpp == 24 )
		glTexImage2D ( GL_TEXTURE_2D, 0, GL_RGBA, width, height,
						0, GL_RGB, GL_UNSIGNED_BYTE, image );
	else // bpp == 8
		glTexImage2D ( GL_TEXTURE_2D, 0, GL_RGBA, width, height,
						0, GL_ALPHA, GL_UNSIGNED_BYTE, image );

	free ( image );
}
